/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client;

import io.netty.channel.EventLoopGroup;
import io.netty.util.Timer;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import java.util.LinkedHashSet;
import java.util.List;
import org.opendaylight.netconf.client.NetconfClientDispatcher;
import org.opendaylight.netconf.client.NetconfClientSession;
import org.opendaylight.netconf.client.NetconfClientSessionListener;
import org.opendaylight.netconf.client.NetconfClientSessionNegotiatorFactory;
import org.opendaylight.netconf.client.SshClientChannelInitializer;
import org.opendaylight.netconf.client.TcpClientChannelInitializer;
import org.opendaylight.netconf.client.TlsClientChannelInitializer;
import org.opendaylight.netconf.client.conf.NetconfClientConfiguration;
import org.opendaylight.netconf.client.conf.NetconfReconnectingClientConfiguration;
import org.opendaylight.netconf.nettyutil.AbstractNetconfDispatcher;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfClientDispatcherImpl
extends AbstractNetconfDispatcher<NetconfClientSession, NetconfClientSessionListener>
implements NetconfClientDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfClientDispatcherImpl.class);
    private final Timer timer;

    public NetconfClientDispatcherImpl(EventLoopGroup bossGroup, EventLoopGroup workerGroup, Timer timer) {
        super(bossGroup, workerGroup);
        this.timer = timer;
    }

    protected Timer getTimer() {
        return this.timer;
    }

    @Override
    public Future<NetconfClientSession> createClient(NetconfClientConfiguration clientConfiguration) {
        switch (clientConfiguration.getProtocol()) {
            case TCP: {
                return this.createTcpClient(clientConfiguration);
            }
            case SSH: {
                return this.createSshClient(clientConfiguration);
            }
            case TLS: {
                return this.createTlsClient(clientConfiguration);
            }
        }
        throw new IllegalArgumentException("Unknown client protocol " + (Object)((Object)clientConfiguration.getProtocol()));
    }

    @Override
    public Future<Void> createReconnectingClient(NetconfReconnectingClientConfiguration clientConfiguration) {
        switch (clientConfiguration.getProtocol()) {
            case TCP: {
                return this.createReconnectingTcpClient(clientConfiguration);
            }
            case SSH: {
                return this.createReconnectingSshClient(clientConfiguration);
            }
            case TLS: {
                return this.createReconnectingTlsClient(clientConfiguration);
            }
        }
        throw new IllegalArgumentException("Unknown client protocol " + (Object)((Object)clientConfiguration.getProtocol()));
    }

    private Future<NetconfClientSession> createTcpClient(NetconfClientConfiguration currentConfiguration) {
        LOG.debug("Creating TCP client with configuration: {}", (Object)currentConfiguration);
        return super.createClient(currentConfiguration.getAddress(), currentConfiguration.getReconnectStrategy(), (ch, promise) -> new TcpClientChannelInitializer(this.getNegotiatorFactory(currentConfiguration), currentConfiguration.getSessionListener()).initialize(ch, (Promise<NetconfClientSession>)promise));
    }

    private Future<Void> createReconnectingTcpClient(NetconfReconnectingClientConfiguration currentConfiguration) {
        LOG.debug("Creating reconnecting TCP client with configuration: {}", (Object)currentConfiguration);
        TcpClientChannelInitializer init = new TcpClientChannelInitializer(this.getNegotiatorFactory(currentConfiguration), currentConfiguration.getSessionListener());
        return super.createReconnectingClient(currentConfiguration.getAddress(), currentConfiguration.getConnectStrategyFactory(), currentConfiguration.getReconnectStrategy(), init::initialize);
    }

    private Future<NetconfClientSession> createSshClient(NetconfClientConfiguration currentConfiguration) {
        LOG.debug("Creating SSH client with configuration: {}", (Object)currentConfiguration);
        return super.createClient(currentConfiguration.getAddress(), currentConfiguration.getReconnectStrategy(), (ch, sessionPromise) -> new SshClientChannelInitializer(currentConfiguration.getAuthHandler(), this.getNegotiatorFactory(currentConfiguration), currentConfiguration.getSessionListener()).initialize(ch, (Promise<NetconfClientSession>)sessionPromise));
    }

    private Future<Void> createReconnectingSshClient(NetconfReconnectingClientConfiguration currentConfiguration) {
        LOG.debug("Creating reconnecting SSH client with configuration: {}", (Object)currentConfiguration);
        SshClientChannelInitializer init = new SshClientChannelInitializer(currentConfiguration.getAuthHandler(), this.getNegotiatorFactory(currentConfiguration), currentConfiguration.getSessionListener());
        return super.createReconnectingClient(currentConfiguration.getAddress(), currentConfiguration.getConnectStrategyFactory(), currentConfiguration.getReconnectStrategy(), init::initialize);
    }

    private Future<NetconfClientSession> createTlsClient(NetconfClientConfiguration currentConfiguration) {
        LOG.debug("Creating TLS client with configuration: {}", (Object)currentConfiguration);
        return super.createClient(currentConfiguration.getAddress(), currentConfiguration.getReconnectStrategy(), (ch, sessionPromise) -> new TlsClientChannelInitializer(currentConfiguration.getSslHandlerFactory(), this.getNegotiatorFactory(currentConfiguration), currentConfiguration.getSessionListener()).initialize(ch, (Promise<NetconfClientSession>)sessionPromise));
    }

    private Future<Void> createReconnectingTlsClient(NetconfReconnectingClientConfiguration currentConfiguration) {
        LOG.debug("Creating reconnecting TLS client with configuration: {}", (Object)currentConfiguration);
        TlsClientChannelInitializer init = new TlsClientChannelInitializer(currentConfiguration.getSslHandlerFactory(), this.getNegotiatorFactory(currentConfiguration), currentConfiguration.getSessionListener());
        return super.createReconnectingClient(currentConfiguration.getAddress(), currentConfiguration.getConnectStrategyFactory(), currentConfiguration.getReconnectStrategy(), init::initialize);
    }

    protected NetconfClientSessionNegotiatorFactory getNegotiatorFactory(NetconfClientConfiguration cfg) {
        List<Uri> odlHelloCapabilities = cfg.getOdlHelloCapabilities();
        if (odlHelloCapabilities == null || odlHelloCapabilities.isEmpty()) {
            return new NetconfClientSessionNegotiatorFactory(this.timer, cfg.getAdditionalHeader(), cfg.getConnectionTimeoutMillis());
        }
        LinkedHashSet<String> stringCapabilities = new LinkedHashSet<String>();
        for (Uri uri : odlHelloCapabilities) {
            stringCapabilities.add(uri.getValue());
        }
        return new NetconfClientSessionNegotiatorFactory(this.timer, cfg.getAdditionalHeader(), (long)cfg.getConnectionTimeoutMillis(), stringCapabilities);
    }
}

