/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.MessageToByteEncoder;
import java.util.Collection;
import org.opendaylight.netconf.api.NetconfMessage;
import org.opendaylight.netconf.api.NetconfSessionListener;
import org.opendaylight.netconf.client.NetconfClientSessionListener;
import org.opendaylight.netconf.nettyutil.AbstractNetconfSession;
import org.opendaylight.netconf.nettyutil.handler.NetconfMessageToXMLEncoder;
import org.opendaylight.netconf.nettyutil.handler.NetconfXMLToMessageDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfClientSession
extends AbstractNetconfSession<NetconfClientSession, NetconfClientSessionListener> {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfClientSession.class);
    private final Collection<String> capabilities;

    public NetconfClientSession(NetconfClientSessionListener sessionListener, Channel channel, long sessionId, Collection<String> capabilities) {
        super((NetconfSessionListener)sessionListener, channel, sessionId);
        this.capabilities = capabilities;
        LOG.debug("Client Session {} created", (Object)this);
    }

    public Collection<String> getServerCapabilities() {
        return this.capabilities;
    }

    protected NetconfClientSession thisInstance() {
        return this;
    }

    protected void addExiHandlers(ByteToMessageDecoder decoder, MessageToByteEncoder<NetconfMessage> encoder) {
        this.replaceMessageDecoder((ChannelHandler)decoder);
        this.replaceMessageEncoder((ChannelHandler)encoder);
    }

    public void stopExiCommunication() {
        this.replaceMessageDecoder((ChannelHandler)new NetconfXMLToMessageDecoder());
        this.replaceMessageEncoder((ChannelHandler)new NetconfMessageToXMLEncoder());
    }
}

