/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.util.concurrent.Promise;
import org.opendaylight.netconf.api.NetconfSessionListenerFactory;
import org.opendaylight.netconf.client.NetconfClientSession;
import org.opendaylight.netconf.client.NetconfClientSessionListener;
import org.opendaylight.netconf.client.NetconfClientSessionNegotiatorFactory;
import org.opendaylight.netconf.nettyutil.AbstractChannelInitializer;
import org.opendaylight.netconf.nettyutil.handler.ssh.authentication.AuthenticationHandler;
import org.opendaylight.netconf.nettyutil.handler.ssh.client.AsyncSshHandler;

final class SshClientChannelInitializer
extends AbstractChannelInitializer<NetconfClientSession> {
    private final AuthenticationHandler authenticationHandler;
    private final NetconfClientSessionNegotiatorFactory negotiatorFactory;
    private final NetconfClientSessionListener sessionListener;

    SshClientChannelInitializer(AuthenticationHandler authHandler, NetconfClientSessionNegotiatorFactory negotiatorFactory, NetconfClientSessionListener sessionListener) {
        this.authenticationHandler = authHandler;
        this.negotiatorFactory = negotiatorFactory;
        this.sessionListener = sessionListener;
    }

    public void initialize(Channel ch, Promise<NetconfClientSession> promise) {
        ch.pipeline().addFirst(new ChannelHandler[]{AsyncSshHandler.createForNetconfSubsystem((AuthenticationHandler)this.authenticationHandler, promise)});
        super.initialize(ch, promise);
    }

    protected void initializeSessionNegotiator(Channel ch, Promise<NetconfClientSession> promise) {
        ch.pipeline().addAfter("netconfMessageDecoder", "negotiator", (ChannelHandler)this.negotiatorFactory.getSessionNegotiator((NetconfSessionListenerFactory<NetconfClientSessionListener>)((NetconfSessionListenerFactory)() -> this.sessionListener), ch, promise));
    }
}

