/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.net.SocketAddress;
import org.opendaylight.netconf.api.NetconfSessionListenerFactory;
import org.opendaylight.netconf.client.NetconfClientSession;
import org.opendaylight.netconf.client.NetconfClientSessionListener;
import org.opendaylight.netconf.client.NetconfClientSessionNegotiatorFactory;
import org.opendaylight.netconf.nettyutil.AbstractChannelInitializer;

class TcpClientChannelInitializer
extends AbstractChannelInitializer<NetconfClientSession> {
    private final NetconfClientSessionNegotiatorFactory negotiatorFactory;
    private final NetconfClientSessionListener sessionListener;

    TcpClientChannelInitializer(NetconfClientSessionNegotiatorFactory negotiatorFactory, NetconfClientSessionListener sessionListener) {
        this.negotiatorFactory = negotiatorFactory;
        this.sessionListener = sessionListener;
    }

    public void initialize(final Channel ch, Promise<NetconfClientSession> promise) {
        Promise<NetconfClientSession> negotiationFuture = promise;
        ch.pipeline().addFirst(new ChannelHandler[]{new ChannelOutboundHandlerAdapter((Future)negotiationFuture){
            ChannelPromise connectPromise;
            GenericFutureListener<Future<NetconfClientSession>> negotiationFutureListener;
            final /* synthetic */ Future val$negotiationFuture;
            {
                this.val$negotiationFuture = future;
            }

            public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise channelPromise) {
                this.connectPromise = channelPromise;
                DefaultChannelPromise tcpConnectFuture = new DefaultChannelPromise(ch);
                this.negotiationFutureListener = future -> {
                    if (future.isSuccess()) {
                        channelPromise.setSuccess();
                    }
                };
                tcpConnectFuture.addListener(future -> {
                    if (future.isSuccess()) {
                        this.val$negotiationFuture.addListener(this.negotiationFutureListener);
                    } else {
                        channelPromise.setFailure(future.cause());
                    }
                });
                ctx.connect(remoteAddress, localAddress, (ChannelPromise)tcpConnectFuture);
            }

            public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
                if (this.connectPromise == null) {
                    return;
                }
                if (this.connectPromise.isSuccess()) {
                    ctx.fireChannelInactive();
                }
                if (!this.connectPromise.isDone()) {
                    this.connectPromise.setFailure((Throwable)new IllegalStateException("Negotiation failed"));
                }
                this.val$negotiationFuture.removeListener(this.negotiationFutureListener);
                super.disconnect(ctx, promise);
                promise.setSuccess();
            }
        }});
        super.initialize(ch, promise);
    }

    protected void initializeSessionNegotiator(Channel ch, Promise<NetconfClientSession> promise) {
        ch.pipeline().addAfter("netconfMessageDecoder", "negotiator", (ChannelHandler)this.negotiatorFactory.getSessionNegotiator((NetconfSessionListenerFactory<NetconfClientSessionListener>)((NetconfSessionListenerFactory)() -> this.sessionListener), ch, promise));
    }
}

