/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.conf;

import java.net.InetSocketAddress;
import java.util.List;
import org.opendaylight.netconf.api.messages.NetconfHelloMessageAdditionalHeader;
import org.opendaylight.netconf.client.NetconfClientSessionListener;
import org.opendaylight.netconf.client.SslHandlerFactory;
import org.opendaylight.netconf.client.conf.NetconfClientConfiguration;
import org.opendaylight.netconf.nettyutil.ReconnectStrategy;
import org.opendaylight.netconf.nettyutil.handler.ssh.authentication.AuthenticationHandler;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;

public class NetconfClientConfigurationBuilder {
    public static final int DEFAULT_CONNECTION_TIMEOUT_MILLIS = 5000;
    public static final NetconfClientConfiguration.NetconfClientProtocol DEFAULT_CLIENT_PROTOCOL = NetconfClientConfiguration.NetconfClientProtocol.TCP;
    private InetSocketAddress address;
    private long connectionTimeoutMillis = 5000L;
    private NetconfHelloMessageAdditionalHeader additionalHeader;
    private NetconfClientSessionListener sessionListener;
    private ReconnectStrategy reconnectStrategy;
    private AuthenticationHandler authHandler;
    private NetconfClientConfiguration.NetconfClientProtocol clientProtocol = DEFAULT_CLIENT_PROTOCOL;
    private SslHandlerFactory sslHandlerFactory;
    private List<Uri> odlHelloCapabilities;

    protected NetconfClientConfigurationBuilder() {
    }

    public static NetconfClientConfigurationBuilder create() {
        return new NetconfClientConfigurationBuilder();
    }

    public NetconfClientConfigurationBuilder withAddress(InetSocketAddress address) {
        this.address = address;
        return this;
    }

    public NetconfClientConfigurationBuilder withConnectionTimeoutMillis(long connectionTimeoutMillis) {
        this.connectionTimeoutMillis = connectionTimeoutMillis;
        return this;
    }

    public NetconfClientConfigurationBuilder withProtocol(NetconfClientConfiguration.NetconfClientProtocol clientProtocol) {
        this.clientProtocol = clientProtocol;
        return this;
    }

    public NetconfClientConfigurationBuilder withAdditionalHeader(NetconfHelloMessageAdditionalHeader additionalHeader) {
        this.additionalHeader = additionalHeader;
        return this;
    }

    public NetconfClientConfigurationBuilder withSessionListener(NetconfClientSessionListener sessionListener) {
        this.sessionListener = sessionListener;
        return this;
    }

    public NetconfClientConfigurationBuilder withReconnectStrategy(ReconnectStrategy reconnectStrategy) {
        this.reconnectStrategy = reconnectStrategy;
        return this;
    }

    public NetconfClientConfigurationBuilder withAuthHandler(AuthenticationHandler authHandler) {
        this.authHandler = authHandler;
        return this;
    }

    public NetconfClientConfigurationBuilder withSslHandlerFactory(SslHandlerFactory sslHandlerFactory) {
        this.sslHandlerFactory = sslHandlerFactory;
        return this;
    }

    public NetconfClientConfigurationBuilder withOdlHelloCapabilities(List<Uri> odlHelloCapabilities) {
        this.odlHelloCapabilities = odlHelloCapabilities;
        return this;
    }

    final InetSocketAddress getAddress() {
        return this.address;
    }

    final long getConnectionTimeoutMillis() {
        return this.connectionTimeoutMillis;
    }

    final NetconfHelloMessageAdditionalHeader getAdditionalHeader() {
        return this.additionalHeader;
    }

    final NetconfClientSessionListener getSessionListener() {
        return this.sessionListener;
    }

    final ReconnectStrategy getReconnectStrategy() {
        return this.reconnectStrategy;
    }

    final AuthenticationHandler getAuthHandler() {
        return this.authHandler;
    }

    final NetconfClientConfiguration.NetconfClientProtocol getProtocol() {
        return this.clientProtocol;
    }

    final SslHandlerFactory getSslHandlerFactory() {
        return this.sslHandlerFactory;
    }

    final List<Uri> getOdlHelloCapabilities() {
        return this.odlHelloCapabilities;
    }

    public NetconfClientConfiguration build() {
        return new NetconfClientConfiguration(this.clientProtocol, this.address, this.connectionTimeoutMillis, this.additionalHeader, this.sessionListener, this.reconnectStrategy, this.authHandler, this.sslHandlerFactory, this.odlHelloCapabilities);
    }
}

