/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.conf;

import java.net.InetSocketAddress;
import java.util.List;
import org.opendaylight.netconf.api.messages.NetconfHelloMessageAdditionalHeader;
import org.opendaylight.netconf.client.NetconfClientSessionListener;
import org.opendaylight.netconf.client.SslHandlerFactory;
import org.opendaylight.netconf.client.conf.NetconfClientConfiguration;
import org.opendaylight.netconf.client.conf.NetconfClientConfigurationBuilder;
import org.opendaylight.netconf.client.conf.NetconfReconnectingClientConfiguration;
import org.opendaylight.netconf.nettyutil.ReconnectStrategy;
import org.opendaylight.netconf.nettyutil.ReconnectStrategyFactory;
import org.opendaylight.netconf.nettyutil.handler.ssh.authentication.AuthenticationHandler;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;

public final class NetconfReconnectingClientConfigurationBuilder
extends NetconfClientConfigurationBuilder {
    private ReconnectStrategyFactory connectStrategyFactory;

    private NetconfReconnectingClientConfigurationBuilder() {
    }

    public static NetconfReconnectingClientConfigurationBuilder create() {
        return new NetconfReconnectingClientConfigurationBuilder();
    }

    public NetconfReconnectingClientConfigurationBuilder withConnectStrategyFactory(ReconnectStrategyFactory connectStrategyFactory) {
        this.connectStrategyFactory = connectStrategyFactory;
        return this;
    }

    @Override
    public NetconfReconnectingClientConfiguration build() {
        return new NetconfReconnectingClientConfiguration(this.getProtocol(), this.getAddress(), this.getConnectionTimeoutMillis(), this.getAdditionalHeader(), this.getSessionListener(), this.getReconnectStrategy(), this.connectStrategyFactory, this.getAuthHandler(), this.getSslHandlerFactory(), this.getOdlHelloCapabilities());
    }

    @Override
    public NetconfReconnectingClientConfigurationBuilder withAddress(InetSocketAddress address) {
        return (NetconfReconnectingClientConfigurationBuilder)super.withAddress(address);
    }

    @Override
    public NetconfReconnectingClientConfigurationBuilder withConnectionTimeoutMillis(long connectionTimeoutMillis) {
        return (NetconfReconnectingClientConfigurationBuilder)super.withConnectionTimeoutMillis(connectionTimeoutMillis);
    }

    @Override
    public NetconfReconnectingClientConfigurationBuilder withAdditionalHeader(NetconfHelloMessageAdditionalHeader additionalHeader) {
        return (NetconfReconnectingClientConfigurationBuilder)super.withAdditionalHeader(additionalHeader);
    }

    @Override
    public NetconfReconnectingClientConfigurationBuilder withSessionListener(NetconfClientSessionListener sessionListener) {
        return (NetconfReconnectingClientConfigurationBuilder)super.withSessionListener(sessionListener);
    }

    @Override
    public NetconfReconnectingClientConfigurationBuilder withReconnectStrategy(ReconnectStrategy reconnectStrategy) {
        return (NetconfReconnectingClientConfigurationBuilder)super.withReconnectStrategy(reconnectStrategy);
    }

    @Override
    public NetconfReconnectingClientConfigurationBuilder withAuthHandler(AuthenticationHandler authHandler) {
        return (NetconfReconnectingClientConfigurationBuilder)super.withAuthHandler(authHandler);
    }

    @Override
    public NetconfReconnectingClientConfigurationBuilder withProtocol(NetconfClientConfiguration.NetconfClientProtocol clientProtocol) {
        return (NetconfReconnectingClientConfigurationBuilder)super.withProtocol(clientProtocol);
    }

    @Override
    public NetconfReconnectingClientConfigurationBuilder withSslHandlerFactory(SslHandlerFactory sslHandlerFactory) {
        return (NetconfReconnectingClientConfigurationBuilder)super.withSslHandlerFactory(sslHandlerFactory);
    }

    @Override
    public NetconfReconnectingClientConfigurationBuilder withOdlHelloCapabilities(List<Uri> odlHelloCapabilities) {
        return (NetconfReconnectingClientConfigurationBuilder)super.withOdlHelloCapabilities(odlHelloCapabilities);
    }
}

