/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.pool.transx.impl;

import java.sql.SQLException;
import java.util.Properties;
import javax.resource.spi.TransactionSupport;
import javax.sql.CommonDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.ops4j.pax.jdbc.pool.transx.impl.TransxPooledDataSourceFactory;
import org.ops4j.pax.transx.jdbc.ManagedDataSourceBuilder;
import org.ops4j.pax.transx.tm.TransactionManager;
import org.osgi.service.jdbc.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransxXaPooledDataSourceFactory
extends TransxPooledDataSourceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TransxXaPooledDataSourceFactory.class);
    private TransactionManager tm;

    public TransxXaPooledDataSourceFactory(TransactionManager tm) {
        this.tm = tm;
    }

    @Override
    public DataSource create(DataSourceFactory dsf, Properties props) throws SQLException {
        try {
            XADataSource ds = dsf.createXADataSource(this.getNonPoolProps(props));
            DataSource mds = ManagedDataSourceBuilder.builder().dataSource((CommonDataSource)ds).transaction(TransactionSupport.TransactionSupportLevel.XATransaction).transactionManager(this.tm).properties(this.getPoolProps(props)).build();
            return mds;
        }
        catch (Throwable e) {
            LOG.error("Error creating pooled datasource" + e.getMessage(), e);
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

