/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc8528.parser;

import org.opendaylight.yangtools.rfc8528.model.api.MountPointEffectiveStatement;
import org.opendaylight.yangtools.rfc8528.model.api.MountPointSchemaNode;
import org.opendaylight.yangtools.rfc8528.model.api.MountPointStatement;
import org.opendaylight.yangtools.rfc8528.model.api.SchemaMountStatements;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.UnknownEffectiveStatementBase;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractDeclaredStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.QNameCacheNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

public final class MountPointStatementSupport
extends AbstractStatementSupport<QName, MountPointStatement, MountPointEffectiveStatement> {
    private static final MountPointStatementSupport INSTANCE = new MountPointStatementSupport((StatementDefinition)SchemaMountStatements.MOUNT_POINT);
    private final SubstatementValidator validator;

    MountPointStatementSupport(StatementDefinition definition) {
        super(definition);
        this.validator = SubstatementValidator.builder((StatementDefinition)definition).addOptional((StatementDefinition)YangStmtMapping.CONFIG).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).build();
    }

    public static MountPointStatementSupport getInstance() {
        return INSTANCE;
    }

    public MountPointStatement createDeclared(StmtContext<QName, MountPointStatement, ?> ctx) {
        return new Declared(ctx);
    }

    public MountPointEffectiveStatement createEffective(StmtContext<QName, MountPointStatement, MountPointEffectiveStatement> ctx) {
        return new Effective(ctx);
    }

    public QName parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return StmtContextUtils.parseIdentifier(ctx, (String)value);
    }

    public QName adaptArgumentValue(StmtContext<QName, MountPointStatement, MountPointEffectiveStatement> ctx, QNameModule targetModule) {
        return (QName)ctx.getFromNamespace(QNameCacheNamespace.class, (Object)((QName)ctx.getStatementArgument()).withModule(targetModule));
    }

    public void onStatementAdded(StmtContext.Mutable<QName, MountPointStatement, MountPointEffectiveStatement> stmt) {
        StatementDefinition parentDef = stmt.coerceParentContext().getPublicDefinition();
        SourceException.throwIf((YangStmtMapping.CONTAINER != parentDef && YangStmtMapping.LIST != parentDef ? 1 : 0) != 0, (StatementSourceReference)stmt.getStatementSourceReference(), (String)"Mount points may only be defined at either a container or a list", (Object[])new Object[0]);
    }

    protected SubstatementValidator getSubstatementValidator() {
        return this.validator;
    }

    private static final class Effective
    extends UnknownEffectiveStatementBase<QName, MountPointStatement>
    implements MountPointEffectiveStatement,
    MountPointSchemaNode {
        private final SchemaPath path;

        Effective(StmtContext<QName, MountPointStatement, ?> ctx) {
            super(ctx);
            this.path = ((SchemaPath)ctx.coerceParentContext().getSchemaPath().get()).createChild((QName)this.argument());
        }

        public QName getQName() {
            return this.path.getLastComponent();
        }

        public SchemaPath getPath() {
            return this.path;
        }
    }

    private static final class Declared
    extends AbstractDeclaredStatement<QName>
    implements MountPointStatement {
        Declared(StmtContext<QName, ?, ?> context) {
            super(context);
        }

        public QName getArgument() {
            return (QName)this.argument();
        }
    }
}

