/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.jline;

import java.io.IOException;
import java.util.Formatter;
import org.apache.felix.gogo.jline.BaseConverters;
import org.apache.felix.service.command.Converter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.startlevel.BundleStartLevel;

public class Converters
extends BaseConverters {
    private final BundleContext context;

    public Converters(BundleContext context) {
        this.context = context;
    }

    private CharSequence print(Bundle bundle) {
        int level = ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).getStartLevel();
        return String.format("%5d|%-11s|%5d|%s (%s)", bundle.getBundleId(), this.getState(bundle), level, bundle.getSymbolicName(), bundle.getVersion());
    }

    private CharSequence print(ServiceReference ref) {
        StringBuilder sb = new StringBuilder();
        Formatter f = new Formatter(sb);
        String spid = "";
        Object pid = ref.getProperty("service.pid");
        if (pid != null) {
            spid = pid.toString();
        }
        f.format("%06d %3s %-40s %s", ref.getProperty("service.id"), ref.getBundle().getBundleId(), this.getShortNames((String[])ref.getProperty("objectclass")), spid);
        return sb;
    }

    private CharSequence getShortNames(String[] list) {
        StringBuilder sb = new StringBuilder();
        String del = "";
        for (String s : list) {
            sb.append(del).append(this.getShortName(s));
            del = " | ";
        }
        return sb;
    }

    private CharSequence getShortName(String name) {
        int n = name.lastIndexOf(46);
        n = n < 0 ? 0 : ++n;
        return name.subSequence(n, name.length());
    }

    private String getState(Bundle bundle) {
        switch (bundle.getState()) {
            case 32: {
                return "Active";
            }
            case 2: {
                return "Installed";
            }
            case 4: {
                return "Resolved";
            }
            case 8: {
                return "Starting";
            }
            case 16: {
                return "Stopping";
            }
            case 1: {
                return "Uninstalled ";
            }
        }
        return null;
    }

    public Bundle bundle(Bundle i) {
        return i;
    }

    @Override
    public Object convert(Class<?> desiredType, Object in) throws Exception {
        if (desiredType == Bundle.class) {
            return this.convertBundle(in);
        }
        if (desiredType == ServiceReference.class) {
            return this.convertServiceReference(in);
        }
        return super.convert(desiredType, in);
    }

    private Object convertServiceReference(Object in) throws InvalidSyntaxException {
        ServiceReference[] refs;
        String s = in.toString();
        if (s.startsWith("(") && s.endsWith(")") && (refs = this.context.getServiceReferences((String)null, String.format("(|(service.id=%s)(service.pid=%s))", in, in))) != null && refs.length > 0) {
            return refs[0];
        }
        refs = this.context.getServiceReferences((String)null, String.format("(|(service.id=%s)(service.pid=%s))", in, in));
        if (refs != null && refs.length > 0) {
            return refs[0];
        }
        return null;
    }

    private Object convertBundle(Object in) {
        String s = in.toString();
        try {
            long id = Long.parseLong(s);
            return this.context.getBundle(id);
        }
        catch (NumberFormatException id) {
            Bundle[] bundles;
            for (Bundle b : bundles = this.context.getBundles()) {
                if (b.getLocation().equals(s)) {
                    return b;
                }
                if (!b.getSymbolicName().equals(s)) continue;
                return b;
            }
            return null;
        }
    }

    @Override
    public CharSequence format(Object target, int level, Converter converter) throws IOException {
        if (level == 1 && target instanceof Bundle) {
            return this.print((Bundle)target);
        }
        if (level == 1 && target instanceof ServiceReference) {
            return this.print((ServiceReference)target);
        }
        if (level == 2 && target instanceof Bundle) {
            return ((Bundle)target).getSymbolicName();
        }
        if (level == 2 && target instanceof ServiceReference) {
            return this.getShortNames((String[])((ServiceReference)target).getProperty("objectclass"));
        }
        return super.format(target, level, converter);
    }
}

