/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import org.apache.aries.subsystem.core.archive.AbstractDirective;

public class CardinalityDirective
extends AbstractDirective {
    public static final String NAME = "cardinality";
    public static final String VALUE_MULTIPLE = "multiple";
    public static final String VALUE_SINGLE = "single";
    public static final CardinalityDirective MULTIPLE = new CardinalityDirective("multiple");
    public static final CardinalityDirective SINGLE;
    public static final CardinalityDirective DEFAULT;

    public static CardinalityDirective getInstance(String value) {
        if (VALUE_SINGLE.equals(value)) {
            return SINGLE;
        }
        if (VALUE_MULTIPLE.equals(value)) {
            return MULTIPLE;
        }
        return new CardinalityDirective(value);
    }

    public CardinalityDirective() {
        this(VALUE_SINGLE);
    }

    public CardinalityDirective(String value) {
        super(NAME, value);
    }

    public boolean isMultiple() {
        return MULTIPLE == this || VALUE_MULTIPLE.equals(this.getValue());
    }

    public boolean isSingle() {
        return SINGLE == this || VALUE_SINGLE.equals(this.getValue());
    }

    static {
        DEFAULT = SINGLE = new CardinalityDirective(VALUE_SINGLE);
    }
}

