/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.aries.subsystem.core.archive.AbstractClause;
import org.apache.aries.subsystem.core.archive.AbstractClauseBasedHeader;
import org.apache.aries.subsystem.core.archive.DeployedContentRequirement;
import org.apache.aries.subsystem.core.archive.DeployedVersionAttribute;
import org.apache.aries.subsystem.core.archive.Patterns;
import org.apache.aries.subsystem.core.archive.ReferenceDirective;
import org.apache.aries.subsystem.core.archive.RequirementHeader;
import org.apache.aries.subsystem.core.archive.StartOrderDirective;
import org.apache.aries.subsystem.core.archive.TypeAttribute;
import org.apache.aries.subsystem.core.internal.ResourceHelper;
import org.apache.aries.subsystem.core.internal.Utils;
import org.osgi.framework.Version;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class DeployedContentHeader
extends AbstractClauseBasedHeader<Clause>
implements RequirementHeader<Clause> {
    public static final String NAME = "Deployed-Content";

    public static DeployedContentHeader newInstance(Collection<Resource> resources) {
        StringBuilder builder = new StringBuilder();
        for (Resource resource : resources) {
            DeployedContentHeader.appendResource(resource, builder, true);
            builder.append(',');
        }
        builder.deleteCharAt(builder.length() - 1);
        return new DeployedContentHeader(builder.toString());
    }

    private static StringBuilder appendResource(Resource resource, StringBuilder builder, boolean referenced) {
        String symbolicName = ResourceHelper.getSymbolicNameAttribute(resource);
        Version version = ResourceHelper.getVersionAttribute(resource);
        String type = ResourceHelper.getTypeAttribute(resource);
        builder.append(symbolicName).append(';').append("deployed-version").append('=').append(version.toString()).append(';').append("type").append('=').append(type).append(';').append("resourceId").append('=').append(Utils.getId(resource)).append(';').append("reference").append(":=").append(referenced);
        return builder;
    }

    public DeployedContentHeader(Collection<Clause> clauses) {
        super(clauses);
    }

    public DeployedContentHeader(String value) {
        super(value, new AbstractClauseBasedHeader.ClauseFactory<Clause>(){

            @Override
            public Clause newInstance(String clause) {
                return new Clause(clause);
            }
        });
    }

    public boolean contains(Resource resource) {
        for (Clause clause : this.getClauses()) {
            if (!clause.contains(resource)) continue;
            return true;
        }
        return false;
    }

    public Clause getClause(Resource resource) {
        String symbolicName = ResourceHelper.getSymbolicNameAttribute(resource);
        Version version = ResourceHelper.getVersionAttribute(resource);
        String type = ResourceHelper.getTypeAttribute(resource);
        for (Clause clause : this.clauses) {
            if (!symbolicName.equals(clause.getPath()) || !clause.getDeployedVersion().equals((Object)version) || !type.equals(clause.getType())) continue;
            return clause;
        }
        return null;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    public boolean isReferenced(Resource resource) {
        Clause clause = this.getClause(resource);
        if (clause == null) {
            return false;
        }
        return clause.isReferenced();
    }

    @Override
    public List<Requirement> toRequirements(Resource resource) {
        ArrayList<Requirement> requirements = new ArrayList<Requirement>(this.clauses.size());
        for (Clause clause : this.clauses) {
            requirements.add(clause.toRequirement(resource));
        }
        return requirements;
    }

    public static class Clause
    extends AbstractClause {
        public static final String ATTRIBUTE_DEPLOYEDVERSION = "deployed-version";
        public static final String ATTRIBUTE_RESOURCEID = "resourceId";
        public static final String ATTRIBUTE_TYPE = "type";
        public static final String DIRECTIVE_REFERENCE = "reference";
        public static final String DIRECTIVE_STARTORDER = "start-order";

        public Clause(String clause) {
            super(Clause.parsePath(clause, Patterns.SYMBOLIC_NAME, false), Clause.parseParameters(clause, false), Clause.generateDefaultParameters(TypeAttribute.DEFAULT, ReferenceDirective.TRUE));
        }

        public Clause(Resource resource) {
            this(resource, true);
        }

        public Clause(Resource resource, boolean referenced) {
            this(DeployedContentHeader.appendResource(resource, new StringBuilder(), referenced).toString());
        }

        public boolean contains(Resource resource) {
            return this.getSymbolicName().equals(ResourceHelper.getSymbolicNameAttribute(resource)) && this.getDeployedVersion().equals((Object)ResourceHelper.getVersionAttribute(resource)) && this.getType().equals(ResourceHelper.getTypeAttribute(resource));
        }

        public Version getDeployedVersion() {
            return ((DeployedVersionAttribute)this.getAttribute(ATTRIBUTE_DEPLOYEDVERSION)).getVersion();
        }

        public String getSymbolicName() {
            return this.path;
        }

        public int getStartOrder() {
            return ((StartOrderDirective)((Object)this.getAttribute(DIRECTIVE_STARTORDER))).getStartOrder();
        }

        public String getType() {
            return ((TypeAttribute)this.getAttribute(ATTRIBUTE_TYPE)).getType();
        }

        public boolean isReferenced() {
            return ((ReferenceDirective)this.getDirective(DIRECTIVE_REFERENCE)).isReferenced();
        }

        public DeployedContentRequirement toRequirement(Resource resource) {
            return new DeployedContentRequirement(this, resource);
        }
    }
}

