/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.util.HashMap;
import java.util.Map;
import org.apache.aries.subsystem.core.archive.AriesProvisionDependenciesDirective;
import org.apache.aries.subsystem.core.archive.CardinalityDirective;
import org.apache.aries.subsystem.core.archive.Directive;
import org.apache.aries.subsystem.core.archive.EffectiveDirective;
import org.apache.aries.subsystem.core.archive.FilterDirective;
import org.apache.aries.subsystem.core.archive.GenericDirective;
import org.apache.aries.subsystem.core.archive.ProvisionPolicyDirective;
import org.apache.aries.subsystem.core.archive.ReferenceDirective;
import org.apache.aries.subsystem.core.archive.ResolutionDirective;
import org.apache.aries.subsystem.core.archive.StartOrderDirective;
import org.apache.aries.subsystem.core.archive.VisibilityDirective;

public class DirectiveFactory {
    private static final Map<String, Creator> map = new HashMap<String, Creator>();

    public static Directive createDirective(String name, String value) {
        Creator creator = map.get(name);
        if (creator == null) {
            return new GenericDirective(name, value);
        }
        return creator.create(value);
    }

    static {
        map.put("apache-aries-provision-dependencies", new Creator(){

            @Override
            public Directive create(String value) {
                return AriesProvisionDependenciesDirective.getInstance(value);
            }
        });
        map.put("cardinality", new Creator(){

            @Override
            public Directive create(String value) {
                return CardinalityDirective.getInstance(value);
            }
        });
        map.put("effective", new Creator(){

            @Override
            public Directive create(String value) {
                return EffectiveDirective.getInstance(value);
            }
        });
        map.put("filter", new Creator(){

            @Override
            public Directive create(String value) {
                return new FilterDirective(value);
            }
        });
        map.put("provision-policy", new Creator(){

            @Override
            public Directive create(String value) {
                return ProvisionPolicyDirective.getInstance(value);
            }
        });
        map.put("reference", new Creator(){

            @Override
            public Directive create(String value) {
                return ReferenceDirective.getInstance(value);
            }
        });
        map.put("resolution", new Creator(){

            @Override
            public Directive create(String value) {
                return ResolutionDirective.getInstance(value);
            }
        });
        map.put("start-order", new Creator(){

            @Override
            public Directive create(String value) {
                return new StartOrderDirective(value);
            }
        });
        map.put("visibility", new Creator(){

            @Override
            public Directive create(String value) {
                return VisibilityDirective.getInstance(value);
            }
        });
    }

    private static interface Creator {
        public Directive create(String var1);
    }
}

