/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.aries.subsystem.core.archive.Attribute;
import org.apache.aries.subsystem.core.archive.Directive;
import org.apache.aries.subsystem.core.archive.FragmentHostHeader;
import org.apache.aries.subsystem.core.internal.AbstractRequirement;
import org.osgi.resource.Resource;

public class FragmentHostRequirement
extends AbstractRequirement {
    public static final String DIRECTIVE_EXTENSION = "extension";
    public static final String DIRECTIVE_FILTER = "filter";
    public static final String NAMESPACE = "osgi.wiring.host";
    private final Map<String, String> directives;
    private final Resource resource;

    public FragmentHostRequirement(FragmentHostHeader.Clause clause, Resource resource) {
        this.directives = new HashMap<String, String>(clause.getDirectives().size() + 1);
        for (Directive directive : clause.getDirectives()) {
            this.directives.put(directive.getName(), directive.getValue());
        }
        StringBuilder builder = new StringBuilder("(&(").append(NAMESPACE).append('=').append(clause.getSymbolicName()).append(')');
        for (Attribute attribute : clause.getAttributes()) {
            attribute.appendToFilter(builder);
        }
        this.directives.put(DIRECTIVE_FILTER, builder.append(')').toString());
        this.resource = resource;
    }

    public Map<String, Object> getAttributes() {
        return Collections.emptyMap();
    }

    public Map<String, String> getDirectives() {
        return Collections.unmodifiableMap(this.directives);
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public Resource getResource() {
        return this.resource;
    }
}

