/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.aries.subsystem.core.archive.AbstractClause;
import org.apache.aries.subsystem.core.archive.AbstractClauseBasedHeader;
import org.apache.aries.subsystem.core.archive.CapabilityHeader;
import org.apache.aries.subsystem.core.archive.EffectiveDirective;
import org.apache.aries.subsystem.core.archive.Parameter;
import org.apache.aries.subsystem.core.archive.Patterns;
import org.apache.aries.subsystem.core.archive.ProvideCapabilityCapability;
import org.osgi.resource.Resource;

public class ProvideCapabilityHeader
extends AbstractClauseBasedHeader<Clause>
implements CapabilityHeader<Clause> {
    public static final String NAME = "Provide-Capability";

    public ProvideCapabilityHeader(String value) {
        super(value, new AbstractClauseBasedHeader.ClauseFactory<Clause>(){

            @Override
            public Clause newInstance(String clause) {
                return new Clause(clause);
            }
        });
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    @Override
    public List<ProvideCapabilityCapability> toCapabilities(Resource resource) {
        ArrayList<ProvideCapabilityCapability> result = new ArrayList<ProvideCapabilityCapability>();
        for (Clause clause : this.clauses) {
            result.add(clause.toCapability(resource));
        }
        return result;
    }

    public static class Clause
    extends AbstractClause {
        public static final String DIRECTIVE_EFFECTIVE = "effective";
        public static final String DIRECTIVE_USES = "uses";
        private static final Collection<Parameter> defaultParameters = Clause.generateDefaultParameters(EffectiveDirective.DEFAULT);

        public Clause(String clause) {
            super(Clause.parsePath(clause, Patterns.NAMESPACE, false), Clause.parseTypedParameters(clause), defaultParameters);
        }

        public String getNamespace() {
            return this.path;
        }

        public ProvideCapabilityCapability toCapability(Resource resource) {
            return new ProvideCapabilityCapability(this, resource);
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder().append(this.getPath());
            for (Parameter parameter : this.getParameters()) {
                builder.append(';').append(parameter);
            }
            return builder.toString();
        }
    }
}

