/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.util.Collection;
import java.util.Collections;
import org.apache.aries.subsystem.core.archive.AbstractClause;
import org.apache.aries.subsystem.core.archive.AbstractClauseBasedHeader;
import org.apache.aries.subsystem.core.archive.AriesProvisionDependenciesDirective;
import org.apache.aries.subsystem.core.archive.Parameter;
import org.apache.aries.subsystem.core.archive.Patterns;
import org.apache.aries.subsystem.core.archive.ProvisionPolicyDirective;

public class SubsystemTypeHeader
extends AbstractClauseBasedHeader<Clause> {
    public static final String DIRECTIVE_PROVISION_DEPENDENCIES = "apache-aries-provision-dependencies";
    public static final String DIRECTIVE_PROVISION_POLICY = "provision-policy";
    public static final String NAME = "Subsystem-Type";
    public static final String ARIES_PROVISION_DEPENDENCIES_INSTALL = "install";
    public static final String ARIES_PROVISION_DEPENDENCIES_RESOLVE = "resolve";
    public static final String PROVISION_POLICY_ACCEPT_DEPENDENCIES = "acceptDependencies";
    public static final String PROVISION_POLICY_REJECT_DEPENDENCIES = "rejectDependencies";
    public static final String TYPE_APPLICATION = "osgi.subsystem.application";
    public static final String TYPE_COMPOSITE = "osgi.subsystem.composite";
    public static final String TYPE_FEATURE = "osgi.subsystem.feature";
    public static final SubsystemTypeHeader DEFAULT = new SubsystemTypeHeader("osgi.subsystem.application");

    public SubsystemTypeHeader(Clause clause) {
        super(Collections.singleton(clause));
    }

    public SubsystemTypeHeader(String value) {
        super(value, new AbstractClauseBasedHeader.ClauseFactory<Clause>(){

            @Override
            public Clause newInstance(String clause) {
                return new Clause(clause);
            }
        });
    }

    public Clause getClause() {
        return (Clause)this.clauses.iterator().next();
    }

    @Override
    public String getName() {
        return NAME;
    }

    public AriesProvisionDependenciesDirective getAriesProvisionDependenciesDirective() {
        return ((Clause)this.clauses.iterator().next()).getProvisionDependenciesDirective();
    }

    public ProvisionPolicyDirective getProvisionPolicyDirective() {
        return ((Clause)this.clauses.iterator().next()).getProvisionPolicyDirective();
    }

    public String getType() {
        return ((Clause)this.clauses.iterator().next()).getType();
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    public boolean isApplication() {
        return this == DEFAULT || TYPE_APPLICATION.equals(this.getType());
    }

    public boolean isComposite() {
        return TYPE_COMPOSITE.equals(this.getType());
    }

    public boolean isFeature() {
        return TYPE_FEATURE.equals(this.getType());
    }

    public static class Clause
    extends AbstractClause {
        private static final Collection<Parameter> defaultParameters = Clause.generateDefaultParameters(ProvisionPolicyDirective.REJECT_DEPENDENCIES);

        public Clause(String clause) {
            super(Clause.parsePath(clause, Patterns.SUBSYSTEM_TYPE, false), Clause.parseParameters(clause, false), defaultParameters);
        }

        public AriesProvisionDependenciesDirective getProvisionDependenciesDirective() {
            return (AriesProvisionDependenciesDirective)this.getDirective(SubsystemTypeHeader.DIRECTIVE_PROVISION_DEPENDENCIES);
        }

        public ProvisionPolicyDirective getProvisionPolicyDirective() {
            return (ProvisionPolicyDirective)this.getDirective(SubsystemTypeHeader.DIRECTIVE_PROVISION_POLICY);
        }

        public String getType() {
            return this.path;
        }
    }
}

