/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.aries.subsystem.core.internal.Activator;
import org.apache.aries.subsystem.core.internal.BundleDirectory;
import org.apache.aries.subsystem.core.internal.ServiceModeller;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class BundleRevisionResource
implements Resource {
    private final BundleRevision revision;
    private boolean initialized;
    private List<Capability> serviceCapabilities;
    private List<Requirement> serviceRequirements;

    public BundleRevisionResource(BundleRevision revision) {
        if (revision == null) {
            throw new NullPointerException();
        }
        this.revision = revision;
    }

    public List<Capability> getCapabilities(String namespace) {
        if ("osgi.service".equals(namespace)) {
            return Collections.unmodifiableList(this.getServiceCapabilities());
        }
        List revisionCapabilities = this.revision.getCapabilities(namespace);
        if (namespace == null) {
            List<Capability> serviceCapabilities = this.getServiceCapabilities();
            ArrayList<Capability> result = new ArrayList<Capability>(revisionCapabilities.size() + serviceCapabilities.size());
            result.addAll(revisionCapabilities);
            result.addAll(serviceCapabilities);
            return Collections.unmodifiableList(result);
        }
        return revisionCapabilities;
    }

    public List<Requirement> getRequirements(String namespace) {
        if ("osgi.service".equals(namespace)) {
            return Collections.unmodifiableList(this.getServiceRequirements());
        }
        List revisionRequirements = this.revision.getRequirements(namespace);
        if (namespace == null) {
            List<Requirement> serviceRequirements = this.getServiceRequirements();
            ArrayList<Requirement> result = new ArrayList<Requirement>(revisionRequirements.size() + serviceRequirements.size());
            result.addAll(revisionRequirements);
            result.addAll(serviceRequirements);
            return Collections.unmodifiableList(result);
        }
        return revisionRequirements;
    }

    public BundleRevision getRevision() {
        return this.revision;
    }

    private ServiceModeller.ServiceModel getModel() {
        Activator activator = Activator.getInstance();
        ServiceModeller modeller = activator.getServiceModeller();
        if (modeller == null) {
            return null;
        }
        ServiceModeller.ServiceModel model = modeller.computeRequirementsAndCapabilities(this, new BundleDirectory(this.revision.getBundle()));
        return model;
    }

    private synchronized void computeServiceCapabilitiesAndRequirements() {
        ServiceModeller.ServiceModel model = null;
        boolean gotModel = false;
        List<Capability> capabilities = this.revision.getCapabilities("osgi.service");
        if (capabilities.isEmpty()) {
            model = this.getModel();
            gotModel = true;
            if (model != null) {
                capabilities = model.getServiceCapabilities();
            }
        }
        this.serviceCapabilities = capabilities;
        List<Requirement> requirements = this.revision.getRequirements("osgi.service");
        if (requirements.isEmpty()) {
            if (model == null && !gotModel) {
                model = this.getModel();
            }
            if (model != null) {
                requirements = model.getServiceRequirements();
            }
        }
        this.serviceRequirements = requirements;
        this.initialized = true;
    }

    private synchronized List<Capability> getServiceCapabilities() {
        if (!this.initialized) {
            this.computeServiceCapabilitiesAndRequirements();
        }
        return this.serviceCapabilities;
    }

    private synchronized List<Requirement> getServiceRequirements() {
        if (!this.initialized) {
            this.computeServiceCapabilitiesAndRequirements();
        }
        return this.serviceRequirements;
    }
}

