/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.aries.subsystem.core.capabilityset.CapabilitySetRepository;
import org.apache.aries.subsystem.core.repository.Repository;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class ContentRepository
implements Repository {
    private final CapabilitySetRepository installableContent = new CapabilitySetRepository();
    private final CapabilitySetRepository sharedContent;

    public ContentRepository(Collection<Resource> installableContent, Collection<Resource> sharedContent) {
        for (Resource resource : installableContent) {
            this.installableContent.addResource(resource);
        }
        this.sharedContent = new CapabilitySetRepository();
        for (Resource resource : sharedContent) {
            this.sharedContent.addResource(resource);
        }
    }

    @Override
    public Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> requirements) {
        Map<Requirement, Collection<Capability>> result = this.sharedContent.findProviders(requirements);
        for (Map.Entry<Requirement, Collection<Capability>> entry : result.entrySet()) {
            if (!entry.getValue().isEmpty()) continue;
            entry.setValue(this.installableContent.findProviders(Collections.singletonList(entry.getKey())).get(entry.getKey()));
        }
        return result;
    }
}

