/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.aries.subsystem.core.archive.Header;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;

public class GetSubsystemHeadersAction
implements PrivilegedAction<Map<String, String>> {
    private final Locale locale;
    private final BasicSubsystem subsystem;

    public GetSubsystemHeadersAction(BasicSubsystem subsystem, Locale locale) {
        this.subsystem = subsystem;
        this.locale = locale;
    }

    @Override
    public Map<String, String> run() {
        Map<String, Header<?>> headers = this.subsystem.getSubsystemManifest().getHeaders();
        HashMap<String, String> result = new HashMap<String, String>(headers.size());
        for (Map.Entry<String, Header<?>> entry : headers.entrySet()) {
            Header<?> value = entry.getValue();
            result.put(entry.getKey(), this.translate(value.getValue()));
        }
        return result;
    }

    private String translate(String value) {
        URL localizationUrl;
        File localizationFile;
        File rootDir;
        if (this.locale == null || value == null || !value.startsWith("%")) {
            return value;
        }
        String localizationStr = this.subsystem.getSubsystemManifest().getSubsystemLocalizationHeader().getValue();
        try {
            rootDir = this.subsystem.getDirectory().getCanonicalFile();
            localizationFile = new File(rootDir, localizationStr).getCanonicalFile();
        }
        catch (IOException e) {
            return value;
        }
        URI rootUri = rootDir.toURI();
        URI localizationUri = localizationFile.getParentFile().toURI();
        if (rootUri.relativize(localizationUri).equals(localizationUri)) {
            return value;
        }
        try {
            localizationUrl = localizationUri.toURL();
        }
        catch (MalformedURLException e) {
            return value;
        }
        URLClassLoader classLoader = new URLClassLoader(new URL[]{localizationUrl});
        try {
            ResourceBundle rb = ResourceBundle.getBundle(localizationFile.getName(), this.locale, classLoader);
            return rb.getString(value.substring(1));
        }
        catch (Exception e) {
            return value;
        }
    }
}

