/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.io.InputStream;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.aries.subsystem.core.internal.Activator;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.apache.aries.subsystem.core.internal.ResourceInstaller;
import org.apache.aries.subsystem.core.internal.SecurityManager;
import org.apache.aries.subsystem.core.internal.SubsystemResource;
import org.apache.aries.subsystem.core.internal.TargetRegion;
import org.apache.aries.subsystem.core.internal.Utils;
import org.apache.aries.util.filesystem.IDirectory;
import org.osgi.service.coordinator.Coordination;
import org.osgi.service.coordinator.CoordinationException;
import org.osgi.service.subsystem.Subsystem;
import org.osgi.service.subsystem.SubsystemException;

public class InstallAction
implements PrivilegedAction<BasicSubsystem> {
    private final IDirectory content;
    private final AccessControlContext context;
    private final InputStream deploymentManifest;
    private final String location;
    private final BasicSubsystem parent;

    public InstallAction(String location, IDirectory content, BasicSubsystem parent, AccessControlContext context, InputStream deploymentManifest) {
        this.location = location;
        this.content = content;
        this.parent = parent;
        this.context = context;
        this.deploymentManifest = deploymentManifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public BasicSubsystem run() {
        BasicSubsystem result;
        block25: {
            result = null;
            Activator.getInstance().getLockingStrategy().writeLock();
            try {
                Subsystem.State state = this.parent.getState();
                if (Subsystem.State.INSTALLING.equals((Object)state)) {
                    throw new SubsystemException("A child subsystem may not be installed while the parent is in the INSTALLING state");
                }
                Coordination coordination = Utils.createCoordination(this.parent);
                try {
                    TargetRegion region = new TargetRegion(this.parent);
                    SubsystemResource ssr = new SubsystemResource(this.location, this.content, this.parent, coordination);
                    result = Activator.getInstance().getSubsystems().getSubsystemByLocation(this.location);
                    if (result != null) {
                        if (!region.contains((Subsystem)result)) {
                            throw new SubsystemException("Location already exists but existing subsystem is not part of target region: " + this.location);
                        }
                        if (!(result.getSymbolicName().equals(ssr.getSubsystemManifest().getSubsystemSymbolicNameHeader().getSymbolicName()) && result.getVersion().equals((Object)ssr.getSubsystemManifest().getSubsystemVersionHeader().getVersion()) && result.getType().equals(ssr.getSubsystemManifest().getSubsystemTypeHeader().getType()))) {
                            throw new SubsystemException("Location already exists but symbolic name, version, and type are not the same: " + this.location);
                        }
                    } else {
                        result = (BasicSubsystem)region.find(ssr.getSubsystemManifest().getSubsystemSymbolicNameHeader().getSymbolicName(), ssr.getSubsystemManifest().getSubsystemVersionHeader().getVersion());
                        if (result != null) {
                            if (!result.getType().equals(ssr.getSubsystemManifest().getSubsystemTypeHeader().getType())) {
                                throw new SubsystemException("Subsystem already exists in target region but has a different type: " + this.location);
                            }
                        } else {
                            result = new BasicSubsystem(ssr, this.deploymentManifest);
                        }
                    }
                    this.checkLifecyclePermission(result);
                    BasicSubsystem basicSubsystem = (BasicSubsystem)ResourceInstaller.newInstance(coordination, result, this.parent).install();
                    return basicSubsystem;
                }
                catch (Throwable t) {
                    coordination.fail(t);
                    break block25;
                }
                finally {
                    try {
                        coordination.end();
                    }
                    catch (CoordinationException e) {
                        Throwable t = e.getCause();
                        if (t instanceof SubsystemException) {
                            throw (SubsystemException)t;
                        }
                        if (t instanceof SecurityException) {
                            throw (SecurityException)t;
                        }
                        throw new SubsystemException(t);
                    }
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                Activator.getInstance().getLockingStrategy().writeUnlock();
            }
        }
        return result;
    }

    private void checkLifecyclePermission(final BasicSubsystem subsystem) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                SecurityManager.checkLifecyclePermission((Subsystem)subsystem);
                return null;
            }
        }, this.context);
    }
}

