/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.osgi.service.subsystem.Subsystem;
import org.osgi.service.subsystem.SubsystemException;

public class LockingStrategy {
    private final int TRY_LOCK_TIME;
    private final TimeUnit TRY_LOCK_TIME_UNIT = TimeUnit.SECONDS;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final ReentrantReadWriteLock rwlock = new ReentrantReadWriteLock();
    private final ThreadLocal<Map<Subsystem.State, Set<BasicSubsystem>>> local = new ThreadLocal<Map<Subsystem.State, Set<BasicSubsystem>>>(){

        @Override
        protected Map<Subsystem.State, Set<BasicSubsystem>> initialValue() {
            return new HashMap<Subsystem.State, Set<BasicSubsystem>>();
        }
    };

    public LockingStrategy(String tryLockTime) {
        int value = 600;
        if (tryLockTime != null) {
            try {
                value = Integer.parseInt(tryLockTime);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.TRY_LOCK_TIME = value;
    }

    public void lock() {
        try {
            if (!this.lock.tryLock(this.TRY_LOCK_TIME, this.TRY_LOCK_TIME_UNIT)) {
                throw new SubsystemException("Unable to acquire the global mutual exclusion lock in time.");
            }
        }
        catch (InterruptedException e) {
            throw new SubsystemException((Throwable)e);
        }
    }

    public void unlock() {
        this.lock.unlock();
    }

    public void lock(Collection<BasicSubsystem> subsystems) {
        ArrayList<BasicSubsystem> locked = new ArrayList<BasicSubsystem>(subsystems.size());
        try {
            block2: while (locked.size() < subsystems.size()) {
                for (BasicSubsystem subsystem : subsystems) {
                    if (!subsystem.stateChangeLock().tryLock()) {
                        this.unlock(locked);
                        locked.clear();
                        if (this.condition.await(this.TRY_LOCK_TIME, TimeUnit.SECONDS)) continue block2;
                        throw new SubsystemException("Unable to acquire the state change lock in time: " + subsystem);
                    }
                    locked.add(subsystem);
                }
            }
        }
        catch (InterruptedException e) {
            this.unlock(locked);
            throw new SubsystemException((Throwable)e);
        }
    }

    public void unlock(Collection<BasicSubsystem> subsystems) {
        for (BasicSubsystem subsystem : subsystems) {
            subsystem.stateChangeLock().unlock();
        }
        this.signalAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalAll() {
        this.lock();
        try {
            this.condition.signalAll();
        }
        finally {
            this.unlock();
        }
    }

    public boolean set(Subsystem.State state, BasicSubsystem subsystem) {
        Map<Subsystem.State, Set<BasicSubsystem>> map = this.local.get();
        Set<BasicSubsystem> subsystems = map.get(state);
        if (subsystems == null) {
            subsystems = new HashSet<BasicSubsystem>();
            map.put(state, subsystems);
            this.local.set(map);
        }
        if (subsystems.contains(subsystem)) {
            return false;
        }
        subsystems.add(subsystem);
        return true;
    }

    public void unset(Subsystem.State state, BasicSubsystem subsystem) {
        Map<Subsystem.State, Set<BasicSubsystem>> map = this.local.get();
        Set<BasicSubsystem> subsystems = map.get(state);
        if (subsystems != null) {
            subsystems.remove(subsystem);
        }
    }

    public void readLock() {
        try {
            if (!this.rwlock.readLock().tryLock(this.TRY_LOCK_TIME, this.TRY_LOCK_TIME_UNIT)) {
                throw new SubsystemException("Unable to acquire the global read lock in time.");
            }
        }
        catch (InterruptedException e) {
            throw new SubsystemException((Throwable)e);
        }
    }

    public void readUnlock() {
        this.rwlock.readLock().unlock();
    }

    public void writeLock() {
        try {
            if (!this.rwlock.writeLock().tryLock(this.TRY_LOCK_TIME, this.TRY_LOCK_TIME_UNIT)) {
                throw new SubsystemException("Unable to acquire the global write lock in time.");
            }
        }
        catch (InterruptedException e) {
            throw new SubsystemException((Throwable)e);
        }
    }

    public void writeUnlock() {
        this.rwlock.writeLock().unlock();
    }
}

