/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.util.Collection;
import java.util.HashSet;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.osgi.framework.Version;
import org.osgi.service.subsystem.Subsystem;

public class TargetRegion {
    Collection<Subsystem> region = new HashSet<Subsystem>();

    public TargetRegion(BasicSubsystem subsystem) {
        while (!subsystem.isScoped()) {
            subsystem = (BasicSubsystem)subsystem.getParents().iterator().next();
        }
        this.add(subsystem.getChildren());
    }

    public boolean contains(Subsystem subsystem) {
        return this.find(subsystem.getSymbolicName(), subsystem.getVersion()) != null;
    }

    public Subsystem find(String symbolicName, Version version) {
        for (Subsystem s : this.region) {
            if (!s.getSymbolicName().equals(symbolicName) || !s.getVersion().equals((Object)version)) continue;
            return s;
        }
        return null;
    }

    private void add(Collection<Subsystem> children) {
        for (Subsystem child : children) {
            this.region.add(child);
            if (((BasicSubsystem)child).isScoped()) continue;
            this.add(child.getChildren());
        }
    }
}

