/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.util.EnumSet;
import org.apache.aries.subsystem.core.internal.AbstractAction;
import org.apache.aries.subsystem.core.internal.Activator;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.apache.aries.subsystem.core.internal.ResourceUninstaller;
import org.apache.aries.subsystem.core.internal.StopAction;
import org.osgi.service.subsystem.Subsystem;

public class UninstallAction
extends AbstractAction {
    public UninstallAction(BasicSubsystem requestor, BasicSubsystem target, boolean disableRootCheck) {
        super(requestor, target, disableRootCheck);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object run() {
        if (!Activator.getInstance().getLockingStrategy().set(Subsystem.State.UNINSTALLING, this.target)) {
            return null;
        }
        try {
            Activator.getInstance().getLockingStrategy().writeLock();
            try {
                this.checkRoot();
                this.checkValid();
                Subsystem.State state = this.target.getState();
                if (EnumSet.of(Subsystem.State.UNINSTALLED).contains(state)) {
                    Object var2_2 = null;
                    return var2_2;
                }
                if (state.equals((Object)Subsystem.State.ACTIVE)) {
                    new StopAction(this.requestor, this.target, this.disableRootCheck).run();
                }
                ResourceUninstaller.newInstance(this.requestor, this.target).uninstall();
            }
            finally {
                Activator.getInstance().getLockingStrategy().writeUnlock();
            }
        }
        finally {
            Activator.getInstance().getLockingStrategy().unset(Subsystem.State.UNINSTALLING, this.target);
        }
        return null;
    }
}

