/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api.meta;

import com.google.common.annotations.Beta;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.api.meta.ModelStatement;

public interface DeclaredStatement<A>
extends ModelStatement<A> {
    @Nullable
    public String rawArgument();

    public @NonNull Collection<? extends DeclaredStatement<?>> declaredSubstatements();

    default public <S extends DeclaredStatement<?>> @NonNull Collection<? extends S> declaredSubstatements(Class<S> type) {
        Objects.requireNonNull(type);
        return Collections2.transform((Collection)Collections2.filter(this.declaredSubstatements(), type::isInstance), type::cast);
    }

    @Beta
    default public <T extends DeclaredStatement<?>> @NonNull Optional<T> findFirstDeclaredSubstatement(@NonNull Class<T> type) {
        Objects.requireNonNull(type);
        return this.streamDeclaredSubstatements(type).filter(type::isInstance).findFirst().map(type::cast);
    }

    @Beta
    default public <V, T extends DeclaredStatement<V>> @NonNull Optional<V> findFirstDeclaredSubstatementArgument(@NonNull Class<T> type) {
        return this.findFirstDeclaredSubstatement(type).map(ModelStatement::argument);
    }

    @Beta
    default public <T extends DeclaredStatement<?>> @NonNull Stream<T> streamDeclaredSubstatements(@NonNull Class<T> type) {
        Objects.requireNonNull(type);
        return this.declaredSubstatements().stream().filter(type::isInstance).map(type::cast);
    }
}

