/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api.stmt;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

public abstract class SchemaNodeIdentifier
implements Immutable {
    private static final AtomicReferenceFieldUpdater<SchemaNodeIdentifier, ImmutableList> LEGACYPATH_UPDATER = AtomicReferenceFieldUpdater.newUpdater(SchemaNodeIdentifier.class, ImmutableList.class, "legacyPath");
    private static final AtomicReferenceFieldUpdater<SchemaNodeIdentifier, SchemaPath> SCHEMAPATH_UPDATER = AtomicReferenceFieldUpdater.newUpdater(SchemaNodeIdentifier.class, SchemaPath.class, "schemaPath");
    public static final Absolute ROOT = new Absolute(null, null);
    public static final Relative SAME = new Relative(null, null);
    private final SchemaNodeIdentifier parent;
    private final QName qname;
    private final int hash;
    private volatile ImmutableList<QName> legacyPath;
    private volatile SchemaPath schemaPath;

    SchemaNodeIdentifier(SchemaNodeIdentifier parent, QName qname) {
        this.parent = parent;
        this.qname = qname;
        int tmp = Objects.hashCode(parent);
        if (qname != null) {
            tmp = tmp * 31 + qname.hashCode();
        }
        this.hash = tmp;
    }

    private ImmutableList<QName> getLegacyPath() {
        ImmutableList ret = this.legacyPath;
        if (ret == null) {
            ret = ImmutableList.copyOf(this.getPathTowardsRoot()).reverse();
            LEGACYPATH_UPDATER.lazySet(this, ret);
        }
        return ret;
    }

    public static SchemaNodeIdentifier create(Iterable<QName> path, boolean absolute) {
        SchemaNodeIdentifier parent = absolute ? ROOT : SAME;
        return parent.createChild(path);
    }

    public static SchemaNodeIdentifier create(boolean absolute, QName ... path) {
        return SchemaNodeIdentifier.create(Arrays.asList(path), absolute);
    }

    public SchemaNodeIdentifier createChild(Iterable<QName> relative) {
        if (Iterables.isEmpty(relative)) {
            return this;
        }
        SchemaNodeIdentifier parentNode = this;
        for (QName item : relative) {
            parentNode = parentNode.createChild(item);
        }
        return parentNode;
    }

    public SchemaNodeIdentifier createChild(SchemaNodeIdentifier relative) {
        Preconditions.checkArgument((!relative.isAbsolute() ? 1 : 0) != 0, (Object)"Child creation requires relative path");
        return this.createChild(relative.getPathFromRoot());
    }

    public abstract SchemaNodeIdentifier createChild(QName var1);

    public SchemaNodeIdentifier createChild(QName ... elements) {
        return this.createChild(Arrays.asList(elements));
    }

    public Iterable<QName> getPathFromRoot() {
        return this.getLegacyPath();
    }

    public Iterable<QName> getPathTowardsRoot() {
        return () -> new UnmodifiableIterator<QName>(){
            private SchemaNodeIdentifier current;
            {
                this.current = SchemaNodeIdentifier.this;
            }

            public boolean hasNext() {
                return this.current.parent != null;
            }

            public QName next() {
                if (this.current.parent != null) {
                    QName ret = this.current.qname;
                    this.current = this.current.parent;
                    return ret;
                }
                throw new NoSuchElementException("No more elements available");
            }
        };
    }

    public SchemaNodeIdentifier getParent() {
        return this.parent;
    }

    public final QName getLastComponent() {
        return this.qname;
    }

    private SchemaPath createSchemaPath() {
        SchemaPath newPath;
        if (this.parent == null) {
            SchemaPath parentPath = this.isAbsolute() ? SchemaPath.ROOT : SchemaPath.SAME;
            newPath = this.qname == null ? parentPath : parentPath.createChild(this.qname);
        } else {
            newPath = this.parent.asSchemaPath().createChild(this.qname);
        }
        return SCHEMAPATH_UPDATER.compareAndSet(this, null, newPath) ? newPath : this.schemaPath;
    }

    public final SchemaPath asSchemaPath() {
        SchemaPath ret = this.schemaPath;
        return ret != null ? ret : this.createSchemaPath();
    }

    public abstract boolean isAbsolute();

    public final int hashCode() {
        return this.hash;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SchemaNodeIdentifier other = (SchemaNodeIdentifier)obj;
        return Objects.equals(this.qname, other.qname) && Objects.equals(this.parent, other.parent);
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this)).toString();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper.add("path", this.getPathFromRoot());
    }

    public static final class Relative
    extends SchemaNodeIdentifier {
        private Relative(SchemaNodeIdentifier parent, QName qname) {
            super(parent, qname);
        }

        @Override
        public boolean isAbsolute() {
            return false;
        }

        @Override
        public Relative createChild(QName element) {
            return new Relative(this, Objects.requireNonNull(element));
        }
    }

    public static final class Absolute
    extends SchemaNodeIdentifier {
        private Absolute(SchemaNodeIdentifier parent, QName qname) {
            super(parent, qname);
        }

        @Override
        public boolean isAbsolute() {
            return true;
        }

        @Override
        public Absolute createChild(QName element) {
            return new Absolute(this, Objects.requireNonNull(element));
        }
    }
}

