/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api.stmt;

import com.google.common.annotations.Beta;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;

@Beta
public abstract class ValueRange {
    public static ValueRange of(@NonNull Number value) {
        return new Singleton(value);
    }

    public static ValueRange of(@NonNull Number lower, @NonNull Number upper) {
        return lower.equals(upper) ? ValueRange.of(lower) : new Range(lower, upper);
    }

    public abstract @NonNull Number lowerBound();

    public abstract @NonNull Number upperBound();

    public final int hashCode() {
        return Objects.hash(this.lowerBound(), this.upperBound());
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ValueRange)) {
            return false;
        }
        ValueRange other = (ValueRange)obj;
        return this.lowerBound().equals(other.lowerBound()) && this.upperBound().equals(other.upperBound());
    }

    private static final class Range
    extends ValueRange {
        private final @NonNull Number lower;
        private final @NonNull Number upper;

        Range(Number lower, Number upper) {
            this.lower = Objects.requireNonNull(lower);
            this.upper = Objects.requireNonNull(upper);
        }

        @Override
        public @NonNull Number lowerBound() {
            return this.lower;
        }

        @Override
        public @NonNull Number upperBound() {
            return this.upper;
        }

        public String toString() {
            return this.lower + ".." + this.upper;
        }
    }

    private static final class Singleton
    extends ValueRange {
        private final @NonNull Number value;

        Singleton(@NonNull Number value) {
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public @NonNull Number lowerBound() {
            return this.value;
        }

        @Override
        public @NonNull Number upperBound() {
            return this.value;
        }

        public String toString() {
            return this.value.toString();
        }
    }
}

