/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.repo.api;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteSource;
import com.google.common.io.Resources;
import java.io.File;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.YangNames;
import org.opendaylight.yangtools.yang.model.repo.api.DelegatedYangTextSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.api.ResourceYangTextSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.api.RevisionSourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangSchemaSourceRepresentation;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextFileSchemaSource;

@Beta
public abstract class YangTextSchemaSource
extends ByteSource
implements YangSchemaSourceRepresentation {
    private final @NonNull SourceIdentifier identifier;

    protected YangTextSchemaSource(SourceIdentifier identifier) {
        this.identifier = Objects.requireNonNull(identifier);
    }

    public static @NonNull SourceIdentifier identifierFromFilename(String name) {
        Preconditions.checkArgument((boolean)name.endsWith(".yang"), (String)"Filename %s does not end with '%s'", (Object)".yang", (Object)name);
        String baseName = name.substring(0, name.length() - ".yang".length());
        Map.Entry parsed = YangNames.parseFilename((String)baseName);
        return RevisionSourceIdentifier.create((String)parsed.getKey(), Revision.ofNullable((String)((String)parsed.getValue())));
    }

    public static @NonNull YangTextSchemaSource delegateForByteSource(SourceIdentifier identifier, ByteSource delegate) {
        return new DelegatedYangTextSchemaSource(identifier, delegate);
    }

    public static @NonNull YangTextSchemaSource delegateForByteSource(String fileName, ByteSource delegate) {
        return new DelegatedYangTextSchemaSource(YangTextSchemaSource.identifierFromFilename(fileName), delegate);
    }

    public static @NonNull YangTextSchemaSource forFile(File file) {
        Preconditions.checkArgument((boolean)file.isFile(), (String)"Supplied file %s is not a file", (Object)file);
        return new YangTextFileSchemaSource(YangTextSchemaSource.identifierFromFilename(file.getName()), file);
    }

    public static @NonNull ResourceYangTextSchemaSource forResource(String resourceName) {
        return YangTextSchemaSource.forResource(YangTextSchemaSource.class, resourceName);
    }

    public static @NonNull ResourceYangTextSchemaSource forResource(Class<?> clazz, String resourceName) {
        String fileName = resourceName.substring(resourceName.lastIndexOf(47) + 1);
        SourceIdentifier identifier = YangTextSchemaSource.identifierFromFilename(fileName);
        URL url = Resources.getResource(clazz, (String)resourceName);
        return new ResourceYangTextSchemaSource(identifier, url);
    }

    @Override
    public final SourceIdentifier getIdentifier() {
        return this.identifier;
    }

    public Class<? extends YangTextSchemaSource> getType() {
        return YangTextSchemaSource.class;
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this).add("identifier", (Object)this.identifier)).toString();
    }

    protected abstract MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper var1);
}

