/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.repo.api;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteSource;
import com.google.common.io.Resources;
import java.io.File;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.YangNames;
import org.opendaylight.yangtools.yang.model.repo.api.DelegatedYinTextSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.api.ResourceYinTextSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.api.RevisionSourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YinSchemaSourceRepresentation;
import org.opendaylight.yangtools.yang.model.repo.api.YinTextFileSchemaSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public abstract class YinTextSchemaSource
extends ByteSource
implements YinSchemaSourceRepresentation {
    private static final Logger LOG = LoggerFactory.getLogger(YinTextSchemaSource.class);
    private static final String XML_EXTENSION = ".xml";
    private final @NonNull SourceIdentifier identifier;

    protected YinTextSchemaSource(SourceIdentifier identifier) {
        this.identifier = Objects.requireNonNull(identifier);
    }

    public static @NonNull SourceIdentifier identifierFromFilename(String name) {
        String baseName;
        if (name.endsWith(".yin")) {
            baseName = name.substring(0, name.length() - ".yin".length());
        } else if (name.endsWith(XML_EXTENSION)) {
            LOG.warn("XML file {} being loaded as YIN", (Object)name);
            baseName = name.substring(0, name.length() - XML_EXTENSION.length());
        } else {
            throw new IllegalArgumentException("Filename " + name + " does not have a .yin or .xml extension");
        }
        Map.Entry parsed = YangNames.parseFilename((String)baseName);
        return RevisionSourceIdentifier.create((String)parsed.getKey(), Revision.ofNullable((String)((String)parsed.getValue())));
    }

    @Override
    public final SourceIdentifier getIdentifier() {
        return this.identifier;
    }

    public Class<? extends YinTextSchemaSource> getType() {
        return YinTextSchemaSource.class;
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this).add("identifier", (Object)this.identifier)).toString();
    }

    protected abstract MoreObjects.ToStringHelper addToStringAttributes(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull MoreObjects.ToStringHelper var1);

    public static @NonNull YinTextSchemaSource delegateForByteSource(SourceIdentifier identifier, ByteSource delegate) {
        return new DelegatedYinTextSchemaSource(identifier, delegate);
    }

    public static @NonNull YinTextSchemaSource forFile(File file) {
        Preconditions.checkArgument((boolean)file.isFile(), (String)"Supplied file %s is not a file", (Object)file);
        return new YinTextFileSchemaSource(YinTextSchemaSource.identifierFromFilename(file.getName()), file);
    }

    public static @NonNull YinTextSchemaSource forResource(Class<?> clazz, String resourceName) {
        String fileName = resourceName.substring(resourceName.lastIndexOf(47) + 1);
        return new ResourceYinTextSchemaSource(YinTextSchemaSource.identifierFromFilename(fileName), Resources.getResource(clazz, (String)resourceName));
    }
}

