/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.camel.component;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jms.Connection;
import org.apache.activemq.EnhancedConnection;
import org.apache.activemq.Service;
import org.apache.activemq.advisory.DestinationSource;
import org.apache.activemq.camel.component.ActiveMQConfiguration;
import org.apache.activemq.camel.component.CamelEndpointLoader;
import org.apache.activemq.camel.component.OriginalDestinationPropagateStrategy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.camel.CamelContext;
import org.apache.camel.ComponentConfiguration;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.spi.EndpointCompleter;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.connection.SingleConnectionFactory;

public class ActiveMQComponent
extends JmsComponent
implements EndpointCompleter {
    private final CopyOnWriteArrayList<SingleConnectionFactory> singleConnectionFactoryList = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<Service> pooledConnectionFactoryServiceList = new CopyOnWriteArrayList();
    private static final transient Logger LOG = LoggerFactory.getLogger(ActiveMQComponent.class);
    private boolean exposeAllQueues;
    private CamelEndpointLoader endpointLoader;
    private EnhancedConnection connection;
    DestinationSource source;
    boolean sourceInitialized = false;

    public static ActiveMQComponent activeMQComponent() {
        return new ActiveMQComponent();
    }

    public static ActiveMQComponent activeMQComponent(String brokerURL) {
        ActiveMQComponent answer = new ActiveMQComponent();
        if (answer.getConfiguration() instanceof ActiveMQConfiguration) {
            ((ActiveMQConfiguration)answer.getConfiguration()).setBrokerURL(brokerURL);
        }
        return answer;
    }

    public ActiveMQComponent() {
    }

    public ActiveMQComponent(CamelContext context) {
        super(context);
    }

    public ActiveMQComponent(ActiveMQConfiguration configuration) {
        this.setConfiguration(configuration);
    }

    public void setBrokerURL(String brokerURL) {
        if (this.getConfiguration() instanceof ActiveMQConfiguration) {
            ((ActiveMQConfiguration)this.getConfiguration()).setBrokerURL(brokerURL);
        }
    }

    public void setUserName(String userName) {
        this.setUsername(userName);
    }

    public void setTrustAllPackages(boolean trustAllPackages) {
        if (this.getConfiguration() instanceof ActiveMQConfiguration) {
            ((ActiveMQConfiguration)this.getConfiguration()).setTrustAllPackages(trustAllPackages);
        }
    }

    public boolean isExposeAllQueues() {
        return this.exposeAllQueues;
    }

    public void setExposeAllQueues(boolean exposeAllQueues) {
        this.exposeAllQueues = exposeAllQueues;
    }

    public void setUsePooledConnection(boolean usePooledConnection) {
        if (this.getConfiguration() instanceof ActiveMQConfiguration) {
            ((ActiveMQConfiguration)this.getConfiguration()).setUsePooledConnection(usePooledConnection);
        }
    }

    public void setUseSingleConnection(boolean useSingleConnection) {
        if (this.getConfiguration() instanceof ActiveMQConfiguration) {
            ((ActiveMQConfiguration)this.getConfiguration()).setUseSingleConnection(useSingleConnection);
        }
    }

    protected void addPooledConnectionFactoryService(Service pooledConnectionFactoryService) {
        this.pooledConnectionFactoryServiceList.add(pooledConnectionFactoryService);
    }

    protected void addSingleConnectionFactory(SingleConnectionFactory singleConnectionFactory) {
        this.singleConnectionFactoryList.add(singleConnectionFactory);
    }

    protected String convertPathToActualDestination(String path, Map<String, Object> parameters) {
        String query;
        Map options = IntrospectionSupport.extractProperties(parameters, (String)"destination.");
        try {
            query = URISupport.createQueryString((Map)options);
        }
        catch (URISyntaxException e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
        if (ObjectHelper.isNotEmpty((Object)query)) {
            return path + "?" + query;
        }
        return path;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.isExposeAllQueues()) {
            this.createDestinationSource();
            this.endpointLoader = new CamelEndpointLoader(this.getCamelContext(), this.source);
            this.endpointLoader.afterPropertiesSet();
        }
        if (this.getMessageCreatedStrategy() == null) {
            this.setMessageCreatedStrategy(new OriginalDestinationPropagateStrategy());
        }
    }

    protected void createDestinationSource() {
        try {
            if (this.source == null) {
                if (this.connection == null) {
                    Connection value = this.getConfiguration().getConnectionFactory().createConnection();
                    if (!(value instanceof EnhancedConnection)) {
                        throw new IllegalArgumentException("Created JMS Connection is not an EnhancedConnection: " + value);
                    }
                    this.connection = (EnhancedConnection)value;
                    this.connection.start();
                }
                this.source = this.connection.getDestinationSource();
            }
        }
        catch (Throwable t) {
            LOG.info("Can't get destination source, endpoint completer will not work", t);
        }
    }

    protected void doStop() throws Exception {
        if (this.source != null) {
            this.source.stop();
            this.source = null;
        }
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
        for (Service service : this.pooledConnectionFactoryServiceList) {
            service.stop();
        }
        this.pooledConnectionFactoryServiceList.clear();
        for (SingleConnectionFactory singleConnectionFactory : this.singleConnectionFactoryList) {
            singleConnectionFactory.destroy();
        }
        this.singleConnectionFactoryList.clear();
        super.doStop();
    }

    public void setConfiguration(JmsConfiguration configuration) {
        if (configuration instanceof ActiveMQConfiguration) {
            ((ActiveMQConfiguration)configuration).setActiveMQComponent(this);
        }
        super.setConfiguration(configuration);
    }

    protected JmsConfiguration createConfiguration() {
        ActiveMQConfiguration answer = new ActiveMQConfiguration();
        answer.setActiveMQComponent(this);
        return answer;
    }

    public List<String> completeEndpointPath(ComponentConfiguration componentConfiguration, String completionText) {
        if (!this.sourceInitialized) {
            this.createDestinationSource();
            this.sourceInitialized = true;
        }
        ArrayList<String> answer = new ArrayList<String>();
        if (this.source != null) {
            Set<ActiveMQDestination> candidates = this.source.getQueues();
            String destinationName = completionText;
            if (completionText.startsWith("topic:")) {
                candidates = this.source.getTopics();
                destinationName = completionText.substring(6);
            } else if (completionText.startsWith("queue:")) {
                destinationName = completionText.substring(6);
            }
            for (ActiveMQDestination destination : candidates) {
                if (!destination.getPhysicalName().startsWith(destinationName)) continue;
                answer.add(destination.getPhysicalName());
            }
        }
        return answer;
    }
}

