/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.proton.codec.AMQPType;
import org.apache.qpid.proton.codec.AbstractPrimitiveType;
import org.apache.qpid.proton.codec.ArrayType;
import org.apache.qpid.proton.codec.DecodeException;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.LargeFloatingSizePrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.PrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.SmallFloatingSizePrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.TypeConstructor;
import org.apache.qpid.proton.codec.TypeEncoding;

public class MapType
extends AbstractPrimitiveType<Map> {
    private final MapEncoding _mapEncoding;
    private final MapEncoding _shortMapEncoding;
    private EncoderImpl _encoder;
    private AMQPType fixedKeyType;

    MapType(EncoderImpl encoder, DecoderImpl decoder) {
        this._encoder = encoder;
        this._mapEncoding = new AllMapEncoding(encoder, decoder);
        this._shortMapEncoding = new ShortMapEncoding(encoder, decoder);
        encoder.register(Map.class, this);
        decoder.register(this);
    }

    @Override
    public Class<Map> getTypeClass() {
        return Map.class;
    }

    public void setKeyEncoding(AMQPType<?> keyType) {
        this.fixedKeyType = keyType;
    }

    public MapEncoding getEncoding(Map val) {
        int calculatedSize = MapType.calculateSize(val, this._encoder, this.fixedKeyType);
        MapEncoding encoding = val.size() > 127 || calculatedSize >= 254 ? this._mapEncoding : this._shortMapEncoding;
        encoding.setValue(val, calculatedSize);
        return encoding;
    }

    private static int calculateSize(Map map2, EncoderImpl encoder, AMQPType<?> fixedKeyType) {
        int len = 0;
        for (Map.Entry element : map2.entrySet()) {
            AMQPType keyType = fixedKeyType;
            if (fixedKeyType == null) {
                keyType = encoder.getType(element.getKey());
            }
            TypeEncoding<Object> elementEncoding = keyType.getEncoding(element.getKey());
            len += elementEncoding.getConstructorSize() + elementEncoding.getValueSize(element.getKey());
            elementEncoding = encoder.getType(element.getValue()).getEncoding(element.getValue());
            len += elementEncoding.getConstructorSize() + elementEncoding.getValueSize(element.getValue());
        }
        return len;
    }

    private static TypeConstructor<?> findNextDecoder(DecoderImpl decoder, ByteBuffer buffer, TypeConstructor<?> previousConstructor) {
        if (previousConstructor == null) {
            return decoder.readConstructor();
        }
        byte encodingCode = buffer.get(buffer.position());
        if (encodingCode == 0 || !(previousConstructor instanceof PrimitiveTypeEncoding)) {
            return decoder.readConstructor();
        }
        PrimitiveTypeEncoding primitiveConstructor = (PrimitiveTypeEncoding)previousConstructor;
        if (encodingCode != primitiveConstructor.getEncodingCode()) {
            return decoder.readConstructor();
        }
        byte by = buffer.get();
        return previousConstructor;
    }

    public MapEncoding getCanonicalEncoding() {
        return this._mapEncoding;
    }

    @Override
    public Collection<MapEncoding> getAllEncodings() {
        return Arrays.asList(this._shortMapEncoding, this._mapEncoding);
    }

    private class ShortMapEncoding
    extends SmallFloatingSizePrimitiveTypeEncoding<Map>
    implements MapEncoding {
        private Map _value;
        private int _length;

        public ShortMapEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        @Override
        protected void writeEncodedValue(Map map2) {
            this.getEncoder().writeRaw((byte)(2 * map2.size()));
            for (Map.Entry element : map2.entrySet()) {
                AMQPType keyType = MapType.this.fixedKeyType;
                if (keyType == null) {
                    keyType = this.getEncoder().getType(element.getKey());
                }
                TypeEncoding<Object> elementEncoding = keyType.getEncoding(element.getKey());
                elementEncoding.writeConstructor();
                elementEncoding.writeValue(element.getKey());
                elementEncoding = this.getEncoder().getType(element.getValue()).getEncoding(element.getValue());
                elementEncoding.writeConstructor();
                elementEncoding.writeValue(element.getValue());
            }
        }

        @Override
        protected int getEncodedValueSize(Map val) {
            return 1 + (val == this._value ? this._length : MapType.calculateSize(val, this.getEncoder(), MapType.this.fixedKeyType));
        }

        @Override
        public byte getEncodingCode() {
            return -63;
        }

        public MapType getType() {
            return MapType.this;
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<Map> encoder) {
            return encoder == this;
        }

        @Override
        public Map readValue() {
            DecoderImpl decoder = this.getDecoder();
            ByteBuffer buffer = decoder.getByteBuffer();
            int size2 = decoder.readRawByte() & 0xFF;
            int count = decoder.readRawByte() & 0xFF;
            TypeConstructor keyConstructor = null;
            TypeConstructor valueConstructor = null;
            LinkedHashMap map2 = new LinkedHashMap(count);
            for (int i = 0; i < count / 2; ++i) {
                if ((keyConstructor = MapType.findNextDecoder(decoder, buffer, keyConstructor)) == null) {
                    throw new DecodeException("Unknown constructor");
                }
                Object key = keyConstructor.readValue();
                boolean arrayType = false;
                byte code = buffer.get(buffer.position());
                switch (code) {
                    case -32: 
                    case -16: {
                        arrayType = true;
                    }
                }
                valueConstructor = MapType.findNextDecoder(decoder, buffer, valueConstructor);
                if (valueConstructor == null) {
                    throw new DecodeException("Unknown constructor");
                }
                Object value = arrayType ? ((ArrayType.ArrayEncoding)valueConstructor).readValueArray() : valueConstructor.readValue();
                map2.put(key, value);
            }
            return map2;
        }

        @Override
        public void skipValue() {
            DecoderImpl decoder = this.getDecoder();
            ByteBuffer buffer = decoder.getByteBuffer();
            int size2 = decoder.readRawByte() & 0xFF;
            buffer.position(buffer.position() + size2);
        }

        @Override
        public void setValue(Map value, int length) {
            this._value = value;
            this._length = length;
        }
    }

    private class AllMapEncoding
    extends LargeFloatingSizePrimitiveTypeEncoding<Map>
    implements MapEncoding {
        private Map _value;
        private int _length;

        public AllMapEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        @Override
        protected void writeEncodedValue(Map map2) {
            this.getEncoder().writeRaw(2 * map2.size());
            for (Map.Entry element : map2.entrySet()) {
                AMQPType keyType = MapType.this.fixedKeyType;
                if (keyType == null) {
                    keyType = this.getEncoder().getType(element.getKey());
                }
                TypeEncoding<Object> elementEncoding = keyType.getEncoding(element.getKey());
                elementEncoding.writeConstructor();
                elementEncoding.writeValue(element.getKey());
                elementEncoding = this.getEncoder().getType(element.getValue()).getEncoding(element.getValue());
                elementEncoding.writeConstructor();
                elementEncoding.writeValue(element.getValue());
            }
        }

        @Override
        protected int getEncodedValueSize(Map val) {
            return 4 + (val == this._value ? this._length : MapType.calculateSize(val, this.getEncoder(), MapType.this.fixedKeyType));
        }

        @Override
        public byte getEncodingCode() {
            return -47;
        }

        public MapType getType() {
            return MapType.this;
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<Map> encoding) {
            return this.getType() == encoding.getType();
        }

        @Override
        public Map readValue() {
            DecoderImpl decoder = this.getDecoder();
            ByteBuffer buffer = decoder.getByteBuffer();
            int size2 = decoder.readRawInt();
            int count = decoder.readRawInt();
            if (count > decoder.getByteBufferRemaining()) {
                throw new IllegalArgumentException("Map element count " + count + " is specified to be greater than the amount of data available (" + decoder.getByteBufferRemaining() + ")");
            }
            TypeConstructor keyConstructor = null;
            TypeConstructor valueConstructor = null;
            LinkedHashMap map2 = new LinkedHashMap(count);
            for (int i = 0; i < count / 2; ++i) {
                if ((keyConstructor = MapType.findNextDecoder(decoder, buffer, keyConstructor)) == null) {
                    throw new DecodeException("Unknown constructor");
                }
                Object key = keyConstructor.readValue();
                boolean arrayType = false;
                byte code = buffer.get(buffer.position());
                switch (code) {
                    case -32: 
                    case -16: {
                        arrayType = true;
                    }
                }
                valueConstructor = MapType.findNextDecoder(decoder, buffer, valueConstructor);
                if (valueConstructor == null) {
                    throw new DecodeException("Unknown constructor");
                }
                Object value = arrayType ? ((ArrayType.ArrayEncoding)valueConstructor).readValueArray() : valueConstructor.readValue();
                map2.put(key, value);
            }
            return map2;
        }

        @Override
        public void skipValue() {
            DecoderImpl decoder = this.getDecoder();
            ByteBuffer buffer = decoder.getByteBuffer();
            int size2 = decoder.readRawInt();
            buffer.position(buffer.position() + size2);
        }

        @Override
        public void setValue(Map value, int length) {
            this._value = value;
            this._length = length;
        }
    }

    private static interface MapEncoding
    extends PrimitiveTypeEncoding<Map> {
        public void setValue(Map var1, int var2);
    }
}

