/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleStatement;
import org.opendaylight.yangtools.yang.model.util.SimpleSchemaContext;

@VisibleForTesting
public final class EffectiveSchemaContext
extends SimpleSchemaContext {
    private final ImmutableList<DeclaredStatement<?>> rootDeclaredStatements;
    private final ImmutableList<EffectiveStatement<?, ?>> rootEffectiveStatements;

    private EffectiveSchemaContext(Set<Module> modules, List<DeclaredStatement<?>> rootDeclaredStatements, List<EffectiveStatement<?, ?>> rootEffectiveStatements) {
        super(modules);
        this.rootDeclaredStatements = ImmutableList.copyOf(rootDeclaredStatements);
        this.rootEffectiveStatements = ImmutableList.copyOf(rootEffectiveStatements);
    }

    static EffectiveSchemaContext create(List<DeclaredStatement<?>> rootDeclaredStatements, List<EffectiveStatement<?, ?>> rootEffectiveStatements) {
        HashSet<Module> modules = new HashSet<Module>();
        for (EffectiveStatement<?, ?> stmt : rootEffectiveStatements) {
            if (!(stmt.getDeclared() instanceof ModuleStatement)) continue;
            Verify.verify((boolean)(stmt instanceof Module));
            modules.add((Module)stmt);
        }
        return new EffectiveSchemaContext(modules, rootDeclaredStatements, rootEffectiveStatements);
    }

    @VisibleForTesting
    public List<DeclaredStatement<?>> getRootDeclaredStatements() {
        return this.rootDeclaredStatements;
    }

    @Beta
    public List<EffectiveStatement<?, ?>> getRootEffectiveStatements() {
        return this.rootEffectiveStatements;
    }
}

