/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.util.OptionalBoolean;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.IdentifierNamespace;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSource;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyHistory;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyType;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceBehaviour;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceKeyCriterion;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.ImplicitSubstatement;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementWriter;
import org.opendaylight.yangtools.yang.parser.spi.source.SupportedFeaturesNamespace;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.NamespaceBehaviourWithListeners;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.NamespaceStorageSupport;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.RootStatementContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementDefinitionContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementMap;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.SubstatementContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StatementContextBase<A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>>
extends NamespaceStorageSupport
implements StmtContext.Mutable<A, D, E>,
StatementWriter.ResumedStatement {
    private static final Logger LOG = LoggerFactory.getLogger(StatementContextBase.class);
    private final @NonNull StatementDefinitionContext<A, D, E> definition;
    private final @NonNull StatementSourceReference statementDeclSource;
    private final StmtContext<?, ?, ?> originalCtx;
    private final CopyHistory copyHistory;
    private final String rawArgument;
    private Multimap<ModelProcessingPhase, OnPhaseFinished> phaseListeners = ImmutableMultimap.of();
    private Multimap<ModelProcessingPhase, ContextMutation> phaseMutation = ImmutableMultimap.of();
    private List<StmtContext.Mutable<?, ?, ?>> effective = ImmutableList.of();
    private List<StmtContext<?, ?, ?>> effectOfStatement = ImmutableList.of();
    private StatementMap substatements = StatementMap.empty();
    private boolean isSupportedToBuildEffective = true;
    private @Nullable ModelProcessingPhase completedPhase;
    private @Nullable D declaredInstance;
    private @Nullable E effectiveInstance;
    private byte supportedByFeatures;
    private boolean fullyDefined;
    private static final Set<YangStmtMapping> NOCOPY_FROM_GROUPING_SET = ImmutableSet.of((Object)YangStmtMapping.DESCRIPTION, (Object)YangStmtMapping.REFERENCE, (Object)YangStmtMapping.STATUS);
    private static final Set<YangStmtMapping> REUSED_DEF_SET = ImmutableSet.of((Object)YangStmtMapping.TYPE, (Object)YangStmtMapping.TYPEDEF, (Object)YangStmtMapping.USES);

    StatementContextBase(StatementDefinitionContext<A, D, E> def, StatementSourceReference ref, String rawArgument) {
        this.definition = Objects.requireNonNull(def);
        this.statementDeclSource = Objects.requireNonNull(ref);
        this.rawArgument = def.internArgument(rawArgument);
        this.copyHistory = CopyHistory.original();
        this.originalCtx = null;
    }

    StatementContextBase(StatementContextBase<A, D, E> original, CopyType copyType) {
        this.definition = original.definition;
        this.statementDeclSource = original.statementDeclSource;
        this.rawArgument = original.rawArgument;
        this.copyHistory = CopyHistory.of((CopyType)copyType, (CopyHistory)original.getCopyHistory());
        this.originalCtx = (StmtContext)original.getOriginalCtx().orElse((StmtContext<?, ?, ?>)original);
    }

    public Collection<? extends StmtContext<?, ?, ?>> getEffectOfStatement() {
        return this.effectOfStatement;
    }

    public void addAsEffectOfStatement(StmtContext<?, ?, ?> ctx) {
        if (this.effectOfStatement.isEmpty()) {
            this.effectOfStatement = new ArrayList(1);
        }
        this.effectOfStatement.add(ctx);
    }

    public void addAsEffectOfStatement(Collection<? extends StmtContext<?, ?, ?>> ctxs) {
        if (ctxs.isEmpty()) {
            return;
        }
        if (this.effectOfStatement.isEmpty()) {
            this.effectOfStatement = new ArrayList(ctxs.size());
        }
        this.effectOfStatement.addAll(ctxs);
    }

    public boolean isSupportedByFeatures() {
        if (OptionalBoolean.isPresent((byte)this.supportedByFeatures)) {
            return OptionalBoolean.get((byte)this.supportedByFeatures);
        }
        if (this.isIgnoringIfFeatures()) {
            this.supportedByFeatures = OptionalBoolean.of((boolean)true);
            return true;
        }
        boolean isParentSupported = this.isParentSupportedByFeatures();
        if (!isParentSupported) {
            this.supportedByFeatures = OptionalBoolean.of((boolean)false);
            return false;
        }
        Set supportedFeatures = (Set)this.getFromNamespace(SupportedFeaturesNamespace.class, SupportedFeaturesNamespace.SupportedFeatures.SUPPORTED_FEATURES);
        boolean ret = supportedFeatures == null ? true : StmtContextUtils.checkFeatureSupport((StmtContext)this, (Set)supportedFeatures);
        this.supportedByFeatures = OptionalBoolean.of((boolean)ret);
        return ret;
    }

    protected abstract boolean isParentSupportedByFeatures();

    protected abstract boolean isIgnoringIfFeatures();

    protected abstract boolean isIgnoringConfig();

    public boolean isSupportedToBuildEffective() {
        return this.isSupportedToBuildEffective;
    }

    public void setIsSupportedToBuildEffective(boolean isSupportedToBuildEffective) {
        this.isSupportedToBuildEffective = isSupportedToBuildEffective;
    }

    public CopyHistory getCopyHistory() {
        return this.copyHistory;
    }

    public Optional<StmtContext<?, ?, ?>> getOriginalCtx() {
        return Optional.ofNullable(this.originalCtx);
    }

    public ModelProcessingPhase getCompletedPhase() {
        return this.completedPhase;
    }

    public void setCompletedPhase(ModelProcessingPhase completedPhase) {
        this.completedPhase = completedPhase;
    }

    public abstract StatementContextBase<?, ?, ?> getParentContext();

    public abstract RootStatementContext<?, ?, ?> getRoot();

    public StatementSource getStatementSource() {
        return this.statementDeclSource.getStatementSource();
    }

    public StatementSourceReference getStatementSourceReference() {
        return this.statementDeclSource;
    }

    public final String rawStatementArgument() {
        return this.rawArgument;
    }

    public Collection<? extends StmtContext<?, ?, ?>> declaredSubstatements() {
        return this.substatements.values();
    }

    public Collection<? extends StmtContext.Mutable<?, ?, ?>> mutableDeclaredSubstatements() {
        return this.substatements.values();
    }

    public Collection<? extends StmtContext<?, ?, ?>> effectiveSubstatements() {
        return this.mutableEffectiveSubstatements();
    }

    public Collection<? extends StmtContext.Mutable<?, ?, ?>> mutableEffectiveSubstatements() {
        if (this.effective instanceof ImmutableCollection) {
            return this.effective;
        }
        return Collections.unmodifiableCollection(this.effective);
    }

    public void removeStatementsFromEffectiveSubstatements(Collection<? extends StmtContext<?, ?, ?>> statements) {
        if (!this.effective.isEmpty()) {
            this.effective.removeAll(statements);
            this.shrinkEffective();
        }
    }

    private void shrinkEffective() {
        if (this.effective.isEmpty()) {
            this.effective = ImmutableList.of();
        }
    }

    public void removeStatementFromEffectiveSubstatements(StatementDefinition statementDef) {
        if (this.effective.isEmpty()) {
            return;
        }
        Iterator<StmtContext.Mutable<?, ?, ?>> iterator = this.effective.iterator();
        while (iterator.hasNext()) {
            StmtContext next = (StmtContext)iterator.next();
            if (!statementDef.equals(next.getPublicDefinition())) continue;
            iterator.remove();
        }
        this.shrinkEffective();
    }

    public void removeStatementFromEffectiveSubstatements(StatementDefinition statementDef, String statementArg) {
        if (statementArg == null) {
            this.removeStatementFromEffectiveSubstatements(statementDef);
        }
        if (this.effective.isEmpty()) {
            return;
        }
        Iterator<StmtContext.Mutable<?, ?, ?>> iterator = this.effective.iterator();
        while (iterator.hasNext()) {
            StmtContext.Mutable<?, ?, ?> next = iterator.next();
            if (!statementDef.equals(next.getPublicDefinition()) || !statementArg.equals(next.rawStatementArgument())) continue;
            iterator.remove();
        }
        this.shrinkEffective();
    }

    public void addEffectiveSubstatement(StmtContext.Mutable<?, ?, ?> substatement) {
        this.beforeAddEffectiveStatement(1);
        this.effective.add(substatement);
    }

    public void addEffectiveSubstatements(Collection<? extends StmtContext.Mutable<?, ?, ?>> statements) {
        if (statements.isEmpty()) {
            return;
        }
        statements.forEach(Objects::requireNonNull);
        this.beforeAddEffectiveStatement(statements.size());
        this.effective.addAll(statements);
    }

    private void beforeAddEffectiveStatement(int toAdd) {
        ModelProcessingPhase inProgressPhase = this.getRoot().getSourceContext().getInProgressPhase();
        Preconditions.checkState((inProgressPhase == ModelProcessingPhase.FULL_DECLARATION || inProgressPhase == ModelProcessingPhase.EFFECTIVE_MODEL ? 1 : 0) != 0, (String)"Effective statement cannot be added in declared phase at: %s", (Object)this.getStatementSourceReference());
        if (this.effective.isEmpty()) {
            this.effective = new ArrayList(toAdd);
        }
    }

    public final <X, Y extends DeclaredStatement<X>, Z extends EffectiveStatement<X, Y>> StatementContextBase<X, Y, Z> createSubstatement(int offset, StatementDefinitionContext<X, Y, Z> def, StatementSourceReference ref, String argument) {
        ModelProcessingPhase inProgressPhase = this.getRoot().getSourceContext().getInProgressPhase();
        Preconditions.checkState((inProgressPhase != ModelProcessingPhase.EFFECTIVE_MODEL ? 1 : 0) != 0, (String)"Declared statement cannot be added in effective phase at: %s", (Object)this.getStatementSourceReference());
        Optional<StatementSupport<?, ?, ?>> implicitParent = this.definition.getImplicitParentFor(def.getPublicView());
        if (implicitParent.isPresent()) {
            return this.createImplicitParent(offset, implicitParent.get(), ref, argument).createSubstatement(offset, def, ref, argument);
        }
        SubstatementContext<X, Y, Z> ret = new SubstatementContext<X, Y, Z>(this, def, ref, argument);
        this.substatements = this.substatements.put(offset, ret);
        def.onStatementAdded(ret);
        return ret;
    }

    private StatementContextBase<?, ?, ?> createImplicitParent(int offset, StatementSupport<?, ?, ?> implicitParent, StatementSourceReference ref, String argument) {
        StatementDefinitionContext def = new StatementDefinitionContext(implicitParent);
        return this.createSubstatement(offset, def, (StatementSourceReference)ImplicitSubstatement.of((StatementSourceReference)ref), argument);
    }

    public void appendImplicitStatement(StatementSupport<?, ?, ?> statementToAdd) {
        this.createSubstatement(this.substatements.capacity(), new StatementDefinitionContext(statementToAdd), (StatementSourceReference)ImplicitSubstatement.of((StatementSourceReference)this.getStatementSourceReference()), null);
    }

    final StatementContextBase<?, ?, ?> lookupSubstatement(int offset) {
        return this.substatements.get(offset);
    }

    final void setFullyDefined() {
        this.fullyDefined = true;
    }

    final void resizeSubstatements(int expectedSize) {
        this.substatements = this.substatements.ensureCapacity(expectedSize);
    }

    final void walkChildren(ModelProcessingPhase phase) {
        Preconditions.checkState((boolean)this.fullyDefined);
        this.substatements.values().forEach(stmt -> {
            stmt.walkChildren(phase);
            stmt.endDeclared(phase);
        });
    }

    public D buildDeclared() {
        Preconditions.checkArgument((this.completedPhase == ModelProcessingPhase.FULL_DECLARATION || this.completedPhase == ModelProcessingPhase.EFFECTIVE_MODEL ? 1 : 0) != 0);
        if (this.declaredInstance == null) {
            this.declaredInstance = this.definition().getFactory().createDeclared((StmtContext)this);
        }
        return this.declaredInstance;
    }

    public E buildEffective() {
        if (this.effectiveInstance == null) {
            this.effectiveInstance = this.definition().getFactory().createEffective((StmtContext)this);
        }
        return this.effectiveInstance;
    }

    boolean tryToCompletePhase(ModelProcessingPhase phase) {
        boolean finished = true;
        Collection openMutations = this.phaseMutation.get((Object)phase);
        if (!openMutations.isEmpty()) {
            Iterator it = openMutations.iterator();
            while (it.hasNext()) {
                ContextMutation contextMutation = (ContextMutation)it.next();
                if (contextMutation.isFinished()) {
                    it.remove();
                    continue;
                }
                finished = false;
            }
            if (openMutations.isEmpty()) {
                this.phaseMutation.removeAll((Object)phase);
                if (this.phaseMutation.isEmpty()) {
                    this.phaseMutation = ImmutableMultimap.of();
                }
            }
        }
        for (StatementContextBase<?, ?, ?> statementContextBase : this.substatements.values()) {
            finished &= statementContextBase.tryToCompletePhase(phase);
        }
        for (StmtContext.Mutable mutable : this.effective) {
            if (!(mutable instanceof StatementContextBase)) continue;
            finished &= ((StatementContextBase)mutable).tryToCompletePhase(phase);
        }
        if (finished) {
            this.onPhaseCompleted(phase);
            return true;
        }
        return false;
    }

    private void onPhaseCompleted(ModelProcessingPhase phase) {
        this.completedPhase = phase;
        Collection listeners = this.phaseListeners.get((Object)phase);
        if (listeners.isEmpty()) {
            return;
        }
        Iterator listener = listeners.iterator();
        while (listener.hasNext()) {
            OnPhaseFinished next = (OnPhaseFinished)listener.next();
            if (!next.phaseFinished(this, phase)) continue;
            listener.remove();
        }
        if (listeners.isEmpty()) {
            this.phaseListeners.removeAll((Object)phase);
            if (this.phaseListeners.isEmpty()) {
                this.phaseListeners = ImmutableMultimap.of();
            }
        }
    }

    void endDeclared(ModelProcessingPhase phase) {
        this.definition().onDeclarationFinished(this, phase);
    }

    protected final @NonNull StatementDefinitionContext<A, D, E> definition() {
        return this.definition;
    }

    @Override
    protected void checkLocalNamespaceAllowed(Class<? extends IdentifierNamespace<?, ?>> type) {
        this.definition().checkNamespaceAllowed(type);
    }

    @Override
    protected <K, V, N extends IdentifierNamespace<K, V>> void onNamespaceElementAdded(Class<N> type, K key, V value) {
    }

    final <K, V, N extends IdentifierNamespace<K, V>> void onNamespaceItemAddedAction(final Class<N> type, final K key, final OnNamespaceItemAdded listener) {
        Object potential = this.getFromNamespace(type, key);
        if (potential != null) {
            LOG.trace("Listener on {} key {} satisfied immediately", type, key);
            listener.namespaceItemAdded(this, type, key, potential);
            return;
        }
        this.getBehaviour(type).addListener(new NamespaceBehaviourWithListeners.KeyedValueAddedListener<K>(this, key){

            @Override
            void onValueAdded(Object value) {
                listener.namespaceItemAdded(StatementContextBase.this, type, key, value);
            }
        });
    }

    final <K, V, N extends IdentifierNamespace<K, V>> void onNamespaceItemAddedAction(final Class<N> type, final ModelProcessingPhase phase, final NamespaceKeyCriterion<K> criterion, final OnNamespaceItemAdded listener) {
        Optional existing = this.getFromNamespace(type, criterion);
        if (existing.isPresent()) {
            Map.Entry entry = existing.get();
            LOG.debug("Listener on {} criterion {} found a pre-existing match: {}", new Object[]{type, criterion, entry});
            this.waitForPhase(entry.getValue(), type, phase, criterion, listener);
            return;
        }
        NamespaceBehaviourWithListeners<K, V, N> behaviour = this.getBehaviour(type);
        behaviour.addListener(new NamespaceBehaviourWithListeners.PredicateValueAddedListener<K, V>(this){

            @Override
            boolean onValueAdded(K key, V value) {
                if (criterion.match(key)) {
                    LOG.debug("Listener on {} criterion {} matched added key {}", new Object[]{type, criterion, key});
                    StatementContextBase.this.waitForPhase(value, type, phase, criterion, listener);
                    return true;
                }
                return false;
            }
        });
    }

    final <K, V, N extends IdentifierNamespace<K, V>> void selectMatch(Class<N> type, NamespaceKeyCriterion<K> criterion, OnNamespaceItemAdded listener) {
        Optional optMatch = this.getFromNamespace(type, criterion);
        Preconditions.checkState((boolean)optMatch.isPresent(), (String)"Failed to find a match for criterion %s in namespace %s node %s", criterion, type, (Object)this);
        Map.Entry match = optMatch.get();
        listener.namespaceItemAdded(this, type, match.getKey(), match.getValue());
    }

    final <K, V, N extends IdentifierNamespace<K, V>> void waitForPhase(Object value, Class<N> type, ModelProcessingPhase phase, NamespaceKeyCriterion<K> criterion, OnNamespaceItemAdded listener) {
        ((StatementContextBase)value).addPhaseCompletedListener(phase, (context, phaseCompleted) -> {
            this.selectMatch(type, criterion, listener);
            return true;
        });
    }

    private <K, V, N extends IdentifierNamespace<K, V>> NamespaceBehaviourWithListeners<K, V, N> getBehaviour(Class<N> type) {
        NamespaceBehaviour behaviour = this.getBehaviourRegistry().getNamespaceBehaviour(type);
        Preconditions.checkArgument((boolean)(behaviour instanceof NamespaceBehaviourWithListeners), (String)"Namespace %s does not support listeners", type);
        return (NamespaceBehaviourWithListeners)behaviour;
    }

    public StatementDefinition getPublicDefinition() {
        return this.definition().getPublicView();
    }

    public ModelActionBuilder newInferenceAction(ModelProcessingPhase phase) {
        return this.getRoot().getSourceContext().newInferenceAction(phase);
    }

    private static <T> Multimap<ModelProcessingPhase, T> newMultimap() {
        return Multimaps.newListMultimap(new EnumMap(ModelProcessingPhase.class), () -> new ArrayList(1));
    }

    void addPhaseCompletedListener(ModelProcessingPhase phase, OnPhaseFinished listener) {
        Preconditions.checkNotNull((Object)phase, (String)"Statement context processing phase cannot be null at: %s", (Object)this.getStatementSourceReference());
        Preconditions.checkNotNull((Object)listener, (String)"Statement context phase listener cannot be null at: %s", (Object)this.getStatementSourceReference());
        for (ModelProcessingPhase finishedPhase = this.completedPhase; finishedPhase != null; finishedPhase = finishedPhase.getPreviousPhase()) {
            if (!phase.equals((Object)finishedPhase)) continue;
            listener.phaseFinished(this, finishedPhase);
            return;
        }
        if (this.phaseListeners.isEmpty()) {
            this.phaseListeners = StatementContextBase.newMultimap();
        }
        this.phaseListeners.put((Object)phase, (Object)listener);
    }

    void addMutation(ModelProcessingPhase phase, ContextMutation mutation) {
        for (ModelProcessingPhase finishedPhase = this.completedPhase; finishedPhase != null; finishedPhase = finishedPhase.getPreviousPhase()) {
            Preconditions.checkState((!phase.equals((Object)finishedPhase) ? 1 : 0) != 0, (String)"Mutation registered after phase was completed at: %s", (Object)this.getStatementSourceReference());
        }
        if (this.phaseMutation.isEmpty()) {
            this.phaseMutation = StatementContextBase.newMultimap();
        }
        this.phaseMutation.put((Object)phase, (Object)mutation);
    }

    public <K, KT extends K, N extends StatementNamespace<K, ?, ?>> void addContext(Class<N> namespace, KT key, StmtContext<?, ?, ?> stmt) {
        this.addContextToNamespace(namespace, key, stmt);
    }

    public <X, Y extends DeclaredStatement<X>, Z extends EffectiveStatement<X, Y>> StmtContext.Mutable<X, Y, Z> childCopyOf(StmtContext<X, Y, Z> stmt, CopyType type, QNameModule targetModule) {
        Preconditions.checkState((stmt.getCompletedPhase() == ModelProcessingPhase.EFFECTIVE_MODEL ? 1 : 0) != 0, (String)"Attempted to copy statement %s which has completed phase %s", stmt, (Object)stmt.getCompletedPhase());
        Preconditions.checkArgument((boolean)(stmt instanceof SubstatementContext), (String)"Unsupported statement %s", stmt);
        SubstatementContext original = (SubstatementContext)stmt;
        SubstatementContext copy = new SubstatementContext(original, this, type, targetModule);
        original.definition().onStatementAdded(copy);
        original.copyTo(copy, type, targetModule);
        return copy;
    }

    public @NonNull StatementDefinition getDefinition() {
        return this.getPublicDefinition();
    }

    public @NonNull StatementSourceReference getSourceReference() {
        return this.getStatementSourceReference();
    }

    public boolean isFullyDefined() {
        return this.fullyDefined;
    }

    final void copyTo(StatementContextBase<?, ?, ?> target, CopyType typeOfCopy, @Nullable QNameModule targetModule) {
        ArrayList buffer = new ArrayList(this.substatements.size() + this.effective.size());
        for (StmtContext.Mutable mutable : this.substatements.values()) {
            if (!mutable.isSupportedByFeatures()) continue;
            this.copySubstatement(mutable, target, typeOfCopy, targetModule, buffer);
        }
        for (StmtContext.Mutable mutable : this.effective) {
            this.copySubstatement(mutable, target, typeOfCopy, targetModule, buffer);
        }
        target.addEffectiveSubstatements(buffer);
    }

    private void copySubstatement(StmtContext.Mutable<?, ?, ?> stmtContext, StmtContext.Mutable<?, ?, ?> target, CopyType typeOfCopy, QNameModule newQNameModule, Collection<StmtContext.Mutable<?, ?, ?>> buffer) {
        if (StatementContextBase.needToCopyByUses(stmtContext)) {
            StmtContext.Mutable copy = target.childCopyOf(stmtContext, typeOfCopy, newQNameModule);
            LOG.debug("Copying substatement {} for {} as {}", new Object[]{stmtContext, this, copy});
            buffer.add(copy);
        } else if (StatementContextBase.isReusedByUses(stmtContext)) {
            LOG.debug("Reusing substatement {} for {}", stmtContext, (Object)this);
            buffer.add(stmtContext);
        } else {
            LOG.debug("Skipping statement {}", stmtContext);
        }
    }

    private static boolean needToCopyByUses(StmtContext<?, ?, ?> stmtContext) {
        StatementDefinition def = stmtContext.getPublicDefinition();
        if (REUSED_DEF_SET.contains(def)) {
            LOG.debug("Will reuse {} statement {}", (Object)def, stmtContext);
            return false;
        }
        if (NOCOPY_FROM_GROUPING_SET.contains(def)) {
            return !YangStmtMapping.GROUPING.equals((Object)stmtContext.coerceParentContext().getPublicDefinition());
        }
        LOG.debug("Will copy {} statement {}", (Object)def, stmtContext);
        return true;
    }

    private static boolean isReusedByUses(StmtContext<?, ?, ?> stmtContext) {
        return REUSED_DEF_SET.contains(stmtContext.getPublicDefinition());
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this).omitNullValues()).toString();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper.add("definition", this.definition).add("rawArgument", (Object)this.rawArgument);
    }

    static interface ContextMutation {
        public boolean isFinished();
    }

    static interface OnPhaseFinished
    extends EventListener {
        public boolean phaseFinished(StatementContextBase<?, ?, ?> var1, ModelProcessingPhase var2);
    }

    static interface OnNamespaceItemAdded
    extends EventListener {
        public void namespaceItemAdded(StatementContextBase<?, ?, ?> var1, Class<?> var2, Object var3, Object var4);
    }
}

