/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import org.opendaylight.yangtools.yang.model.api.meta.IdentifierNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.DerivedNamespaceBehaviour;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceBehaviour;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.NamespaceBehaviourWithListeners;

final class VirtualNamespaceContext<K, V, N extends IdentifierNamespace<K, V>, D>
extends NamespaceBehaviourWithListeners<K, V, N> {
    private final Multimap<D, NamespaceBehaviourWithListeners.KeyedValueAddedListener<K>> listeners = HashMultimap.create();
    private final DerivedNamespaceBehaviour<K, V, D, N, ?> derivedDelegate;

    VirtualNamespaceContext(DerivedNamespaceBehaviour<K, V, D, N, ?> delegate) {
        super(delegate);
        this.derivedDelegate = delegate;
    }

    @Override
    void addListener(NamespaceBehaviourWithListeners.KeyedValueAddedListener<K> listener) {
        this.listeners.put(this.derivedDelegate.getSignificantKey(listener.getKey()), listener);
    }

    @Override
    void addListener(NamespaceBehaviourWithListeners.PredicateValueAddedListener<K, V> listener) {
        throw new UnsupportedOperationException("Virtual namespaces support only exact lookups");
    }

    void addedToSourceNamespace(NamespaceBehaviour.NamespaceStorageNode storage, D key, V value) {
        this.notifyListeners(storage, this.listeners.get(key).iterator(), value);
    }

    @Override
    public void addTo(NamespaceBehaviour.NamespaceStorageNode storage, K key, V value) {
        this.delegate.addTo(storage, key, value);
        this.notifyListeners(storage, this.listeners.get(this.derivedDelegate.getSignificantKey(key)).iterator(), value);
        this.notifyDerivedNamespaces(storage, key, value);
    }
}

