/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.tomcat.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.SessionCookieConfig;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.authenticator.BasicAuthenticator;
import org.apache.catalina.authenticator.DigestAuthenticator;
import org.apache.catalina.authenticator.FormAuthenticator;
import org.apache.catalina.authenticator.NonLoginAuthenticator;
import org.apache.catalina.authenticator.SSLAuthenticator;
import org.apache.catalina.authenticator.SpnegoAuthenticator;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.ContextRuleSet;
import org.apache.catalina.startup.NamingRuleSet;
import org.apache.catalina.startup.Tomcat;
import org.apache.catalina.webresources.TomcatURLStreamHandlerFactory;
import org.apache.tomcat.util.descriptor.XmlErrorHandler;
import org.apache.tomcat.util.descriptor.web.ErrorPage;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.descriptor.web.FilterMap;
import org.apache.tomcat.util.descriptor.web.JspConfigDescriptorImpl;
import org.apache.tomcat.util.descriptor.web.JspPropertyGroup;
import org.apache.tomcat.util.descriptor.web.JspPropertyGroupDescriptorImpl;
import org.apache.tomcat.util.descriptor.web.LoginConfig;
import org.apache.tomcat.util.descriptor.web.SecurityCollection;
import org.apache.tomcat.util.descriptor.web.SecurityConstraint;
import org.apache.tomcat.util.descriptor.web.TaglibDescriptorImpl;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.RuleSet;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.swissbox.core.BundleUtils;
import org.ops4j.pax.web.service.AuthenticatorService;
import org.ops4j.pax.web.service.WebContainerContext;
import org.ops4j.pax.web.service.spi.LifeCycle;
import org.ops4j.pax.web.service.spi.model.ContextModel;
import org.ops4j.pax.web.service.spi.model.ErrorPageModel;
import org.ops4j.pax.web.service.spi.model.EventListenerModel;
import org.ops4j.pax.web.service.spi.model.FilterModel;
import org.ops4j.pax.web.service.spi.model.Model;
import org.ops4j.pax.web.service.spi.model.SecurityConstraintMappingModel;
import org.ops4j.pax.web.service.spi.model.ServletModel;
import org.ops4j.pax.web.service.spi.model.WelcomeFileModel;
import org.ops4j.pax.web.service.spi.util.ResourceDelegatingBundleClassLoader;
import org.ops4j.pax.web.service.tomcat.internal.AddFilterException;
import org.ops4j.pax.web.service.tomcat.internal.EmbeddedTomcat;
import org.ops4j.pax.web.service.tomcat.internal.HttpServiceContext;
import org.ops4j.pax.web.service.tomcat.internal.RemoveContextException;
import org.ops4j.pax.web.service.tomcat.internal.RemoveErrorPageException;
import org.ops4j.pax.web.service.tomcat.internal.ServerStartException;
import org.ops4j.pax.web.service.tomcat.internal.ServerWrapper;
import org.ops4j.pax.web.service.tomcat.internal.ServiceValve;
import org.ops4j.pax.web.service.tomcat.internal.TomcatRemoveServletException;
import org.ops4j.pax.web.service.tomcat.internal.TomcatResourceServlet;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

class TomcatServerWrapper
implements ServerWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(TomcatServerWrapper.class);
    private static final String WEB_CONTEXT_PATH = "Web-ContextPath";
    private final EmbeddedTomcat server;
    private final Map<HttpContext, Context> contextMap = new ConcurrentHashMap<HttpContext, Context>();
    private final Map<FilterModel, FilterLifecycleListener> filterLifecycleListenerMap = new ConcurrentHashMap<FilterModel, FilterLifecycleListener>();
    private final Map<ServletModel, LifecycleListener> servletLifecycleListenerMap = new ConcurrentHashMap<ServletModel, LifecycleListener>();
    private ServiceRegistration<ServletContext> servletContextService;
    private Map<String, Object> contextAttributes;

    private TomcatServerWrapper(EmbeddedTomcat server) {
        NullArgumentException.validateNotNull((Object)server, "server");
        this.server = server;
        ((ContainerBase)server.getHost()).setStartChildren(false);
        TomcatURLStreamHandlerFactory.disable();
    }

    static ServerWrapper getInstance(EmbeddedTomcat server) {
        return new TomcatServerWrapper(server);
    }

    @Override
    public void start() {
        LOG.debug("start server");
        try {
            long t1 = System.nanoTime();
            this.server.getHost();
            this.server.start();
            long t2 = System.nanoTime();
            if (LOG.isInfoEnabled()) {
                LOG.info("TomCat server startup in " + (t2 - t1) / 1000000L + " ms");
            }
        }
        catch (LifecycleException e) {
            throw new ServerStartException(this.server.getServer().toString(), e);
        }
    }

    @Override
    public void stop() {
        LOG.debug("stop server");
        LifecycleState state = this.server.getServer().getState();
        if (LifecycleState.STOPPING_PREP.compareTo((Enum)state) <= 0 && LifecycleState.DESTROYED.compareTo((Enum)state) >= 0) {
            throw new IllegalStateException("stop already called!");
        }
        try {
            this.server.stop();
            this.server.destroy();
        }
        catch (Throwable e) {
            LOG.error("LifecycleException caught {}", e);
        }
    }

    @Override
    public void addServlet(ServletModel model) {
        LOG.debug("add servlet [{}]", (Object)model);
        Context context = this.findOrCreateContext(model.getContextModel());
        String servletName = model.getName();
        if (model.getServlet() == null) {
            try {
                Servlet servlet = model.getServletFromName();
                if (servlet != null) {
                    this.createServletWrapper(model, context, servletName);
                    if (!model.getContextModel().isWebBundle()) {
                        ServletLifecycleListener listener = new ServletLifecycleListener(context, servletName, model);
                        this.servletLifecycleListenerMap.put(model, listener);
                        context.addLifecycleListener((LifecycleListener)listener);
                    }
                } else {
                    Wrapper sw = context.createWrapper();
                    sw.setServletClass(model.getServletClass().getName());
                    this.addServletWrapper(sw, servletName, context, model);
                    if (!model.getContextModel().isWebBundle()) {
                        SerlvetClassNameLifecycleListener listener = new SerlvetClassNameLifecycleListener(context, sw, model, servletName);
                        this.servletLifecycleListenerMap.put(model, listener);
                        context.addLifecycleListener((LifecycleListener)listener);
                    }
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | SecurityException e) {
                LOG.error("failed to create Servlet", (Throwable)e);
            }
        } else {
            this.createServletWrapper(model, context, servletName);
            if (!model.getContextModel().isWebBundle()) {
                WrappedServletLifecycleListener listener = new WrappedServletLifecycleListener(context, servletName, model);
                this.servletLifecycleListenerMap.put(model, listener);
                context.addLifecycleListener((LifecycleListener)listener);
            }
        }
    }

    private void createServletWrapper(ServletModel model, Context context, String servletName) {
        Tomcat.ExistingStandardWrapper sw = new Tomcat.ExistingStandardWrapper(model.getServlet());
        this.addServletWrapper((Wrapper)sw, servletName, context, model);
    }

    private void addServletWrapper(Wrapper sw, String servletName, Context context, ServletModel model) {
        sw.setName(servletName);
        context.addChild((Container)sw);
        this.addServletMappings(context, servletName, model.getUrlPatterns());
        this.addInitParameters(sw, model.getInitParams());
        if (model.getAsyncSupported() != null) {
            sw.setAsyncSupported(model.getAsyncSupported().booleanValue());
        }
        if (model.getLoadOnStartup() != null) {
            sw.setLoadOnStartup(model.getLoadOnStartup().intValue());
        }
        if (model.getMultipartConfig() != null) {
            sw.setMultipartConfigElement(model.getMultipartConfig());
        }
    }

    @Override
    public void removeServlet(ServletModel model) {
        LOG.debug("remove servlet [{}]", (Object)model);
        Context context = this.findContext((Model)model);
        if (context == null) {
            throw new TomcatRemoveServletException("cannot remove servlet cannot find the associated container: " + model);
        }
        LOG.info("remove Servlet");
        LifecycleListener listener = this.servletLifecycleListenerMap.remove(model);
        context.removeLifecycleListener(listener);
        Container servlet = context.findChild(model.getName());
        if (servlet == null) {
            LOG.warn("cannot find the servlet to remove: {}", (Object)model);
        } else {
            String[] urlPatterns = model.getUrlPatterns();
            Arrays.stream(urlPatterns).forEach(pattern -> context.removeServletMapping(pattern));
            context.removeChild(servlet);
        }
    }

    @Override
    public void removeContext(HttpContext httpContext) {
        LOG.debug("remove context [{}]", (Object)httpContext);
        try {
            if (this.servletContextService != null) {
                this.servletContextService.unregister();
            }
        }
        catch (IllegalStateException e) {
            LOG.info("ServletContext service already removed");
        }
        Context context = this.contextMap.remove(httpContext);
        if (context == null) {
            throw new RemoveContextException("cannot remove the context because it does not exist: " + httpContext);
        }
        try {
            context.stop();
        }
        catch (LifecycleException e) {
            throw new RemoveContextException("cannot stop the context: " + httpContext, e);
        }
        this.server.getHost().removeChild((Container)context);
        try {
            LifecycleState state = context.getState();
            if (LifecycleState.DESTROYED != state || LifecycleState.DESTROYING != state) {
                context.destroy();
            }
        }
        catch (LifecycleException e) {
            throw new RemoveContextException("cannot destroy the context: " + httpContext, e);
        }
    }

    @Override
    public void addEventListener(final EventListenerModel eventListenerModel) {
        LOG.debug("add event listener: [{}]", (Object)eventListenerModel);
        final Context context = this.findOrCreateContext((Model)eventListenerModel);
        LifecycleState state = ((HttpServiceContext)context).getState();
        boolean restartContext = false;
        if ((LifecycleState.STARTING.equals((Object)state) || LifecycleState.STARTED.equals((Object)state)) && !eventListenerModel.getContextModel().isWebBundle()) {
            try {
                restartContext = true;
                ((HttpServiceContext)context).stop();
            }
            catch (LifecycleException e) {
                LOG.warn("Can't reset the Lifecycle ... ", (Throwable)e);
            }
        }
        context.addLifecycleListener(new LifecycleListener(){

            public void lifecycleEvent(LifecycleEvent event) {
                if ("before_start".equalsIgnoreCase(event.getType())) {
                    context.getServletContext().addListener(eventListenerModel.getEventListener());
                }
            }
        });
        if (restartContext) {
            try {
                ((HttpServiceContext)context).start();
            }
            catch (LifecycleException e) {
                LOG.warn("Can't reset the Lifecycle ... ", (Throwable)e);
            }
        }
    }

    @Override
    public void removeEventListener(EventListenerModel eventListenerModel) {
        LOG.debug("remove event listener: [{}]", (Object)eventListenerModel);
        NullArgumentException.validateNotNull(eventListenerModel, "eventListenerModel");
        NullArgumentException.validateNotNull(eventListenerModel.getEventListener(), "eventListenerModel#weventListener");
        Context context = this.findOrCreateContext((Model)eventListenerModel);
        LOG.info("removing event listener");
        if (!this.removeApplicationEventListener(context, eventListenerModel.getEventListener()) && !this.removeApplicationLifecycleListener(context, eventListenerModel.getEventListener())) {
            LOG.warn("cannot remove the event lister it is a not support class : {}", (Object)eventListenerModel);
        }
    }

    private boolean removeApplicationLifecycleListener(Context context, EventListener eventListener) {
        if (!this.isApplicationLifecycleListener(eventListener)) {
            return false;
        }
        ArrayList<EventListener> listeners = new ArrayList<EventListener>();
        Object[] applicationLifecycleListeners = context.getApplicationLifecycleListeners();
        boolean found = this.filterEventListener(listeners, applicationLifecycleListeners, eventListener);
        if (found) {
            if (eventListener instanceof ServletContextListener) {
                ((ServletContextListener)eventListener).contextDestroyed(new ServletContextEvent(context.getServletContext()));
            }
            context.setApplicationLifecycleListeners(listeners.toArray());
        }
        return found;
    }

    private boolean isApplicationLifecycleListener(EventListener eventListener) {
        return eventListener instanceof HttpSessionListener || eventListener instanceof ServletContextListener;
    }

    private boolean removeApplicationEventListener(Context context, EventListener eventListener) {
        if (!this.isApplicationEventListener(eventListener)) {
            return false;
        }
        ArrayList<EventListener> newEventListeners = new ArrayList<EventListener>();
        Object[] applicationEventListeners = context.getApplicationEventListeners();
        boolean found = this.filterEventListener(newEventListeners, applicationEventListeners, eventListener);
        if (found) {
            context.setApplicationEventListeners(newEventListeners.toArray());
        }
        return found;
    }

    private boolean filterEventListener(List<EventListener> listeners, Object[] applicationEventListeners, EventListener eventListener) {
        boolean found = false;
        for (Object object : applicationEventListeners) {
            EventListener listener = (EventListener)object;
            if (listener != eventListener) {
                listeners.add(listener);
                continue;
            }
            found = true;
        }
        return found;
    }

    private boolean isApplicationEventListener(EventListener eventListener) {
        return eventListener instanceof ServletContextAttributeListener || eventListener instanceof ServletRequestListener || eventListener instanceof ServletRequestAttributeListener || eventListener instanceof HttpSessionAttributeListener;
    }

    @Override
    public void addFilter(FilterModel filterModel) {
        LOG.debug("add filter [{}]", (Object)filterModel);
        Context context = this.findOrCreateContext((Model)filterModel);
        LifecycleState state = ((HttpServiceContext)context).getState();
        boolean restartContext = false;
        if ((LifecycleState.STARTING.equals((Object)state) || LifecycleState.STARTED.equals((Object)state)) && !filterModel.getContextModel().isWebBundle()) {
            try {
                restartContext = true;
                ((HttpServiceContext)context).stop();
            }
            catch (LifecycleException e) {
                LOG.warn("Can't reset the Lifecycle ... ", (Throwable)e);
            }
        }
        FilterLifecycleListener listener = new FilterLifecycleListener(filterModel, context);
        this.filterLifecycleListenerMap.put(filterModel, listener);
        context.addLifecycleListener((LifecycleListener)listener);
        if (restartContext) {
            try {
                ((HttpServiceContext)context).start();
            }
            catch (LifecycleException e) {
                LOG.warn("Can't reset the Lifecycle ... ", (Throwable)e);
            }
        }
    }

    private EnumSet<DispatcherType> getDispatcherTypes(FilterModel filterModel) {
        ArrayList<DispatcherType> dispatcherTypes = new ArrayList<DispatcherType>(DispatcherType.values().length);
        for (String dispatcherType : filterModel.getDispatcher()) {
            dispatcherTypes.add(DispatcherType.valueOf((String)dispatcherType.toUpperCase()));
        }
        EnumSet<Object> result = EnumSet.noneOf(DispatcherType.class);
        if (dispatcherTypes != null && dispatcherTypes.size() > 0) {
            result = EnumSet.copyOf(dispatcherTypes);
        }
        return result;
    }

    @Override
    public void removeFilter(FilterModel filterModel) {
        FilterMap[] filterMaps;
        Context context = this.findContext((Model)filterModel);
        LOG.info("removing ServletFilter: {}", (Object)filterModel);
        ((StandardContext)context).filterStop();
        FilterLifecycleListener filterLifecycleListener = this.filterLifecycleListenerMap.remove(filterModel);
        context.removeLifecycleListener((LifecycleListener)filterLifecycleListener);
        FilterDef findFilterDef = context.findFilterDef(filterModel.getName());
        if (findFilterDef == null) {
            LOG.warn("no ServletFilter with name: {}", (Object)filterModel.getName());
        } else {
            LOG.info("removing ServletFilter with name: {}", (Object)filterModel.getName());
            context.removeFilterDef(findFilterDef);
        }
        LOG.info("filterDefs now contains {} filters", (Object)context.findFilterDefs().length);
        for (FilterMap filterMap : filterMaps = context.findFilterMaps()) {
            if (!filterMap.getFilterName().equalsIgnoreCase(filterModel.getName())) continue;
            context.removeFilterMap(filterMap);
        }
    }

    @Override
    public void addErrorPage(ErrorPageModel model) {
        Context context = this.findOrCreateContext((Model)model);
        if ("4xx".equals(model.getError())) {
            for (int c = 400; c < 500; ++c) {
                ErrorPage errorPage = this.createErrorPage(model, c);
                context.addErrorPage(errorPage);
            }
        } else if ("5xx".equals(model.getError())) {
            for (int c = 500; c < 600; ++c) {
                ErrorPage errorPage = this.createErrorPage(model, c);
                context.addErrorPage(errorPage);
            }
        } else {
            ErrorPage errorPage = this.createErrorPage(model, null);
            context.addErrorPage(errorPage);
        }
    }

    private ErrorPage createErrorPage(ErrorPageModel model, Integer overrideErrorCode) {
        NullArgumentException.validateNotNull(model, "model");
        NullArgumentException.validateNotNull(model.getLocation(), "model#location");
        NullArgumentException.validateNotNull(model.getError(), "model#error");
        ErrorPage errorPage = new ErrorPage();
        errorPage.setLocation(model.getLocation());
        Integer errorCode = overrideErrorCode == null ? this.parseErrorCode(model.getError()) : overrideErrorCode;
        if (errorCode != null) {
            errorPage.setErrorCode(errorCode.intValue());
        } else if (!"org.ops4j.pax.web.error.error_page.global".equalsIgnoreCase(model.getError())) {
            errorPage.setExceptionType(model.getError());
        }
        return errorPage;
    }

    private Integer parseErrorCode(String errorCode) {
        try {
            return Integer.parseInt(errorCode);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public void removeErrorPage(ErrorPageModel model) {
        Context context = this.findContext((Model)model);
        if (context == null) {
            throw new RemoveErrorPageException("cannot retrieve the associated context: " + model);
        }
        if ("4xx".equals(model.getError())) {
            for (int c = 400; c < 500; ++c) {
                ErrorPage errorPage = this.createErrorPage(model, c);
                context.removeErrorPage(errorPage);
            }
        } else if ("5xx".equals(model.getError())) {
            for (int c = 500; c < 600; ++c) {
                ErrorPage errorPage = this.createErrorPage(model, c);
                context.removeErrorPage(errorPage);
            }
        } else {
            ErrorPage errorPage = this.createErrorPage(model, null);
            context.removeErrorPage(errorPage);
        }
    }

    @Override
    public Servlet createResourceServlet(ContextModel contextModel, String alias, String name) {
        LOG.debug("createResourceServlet( contextModel: {}, alias: {}, name: {})");
        Context context = this.findOrCreateContext(contextModel);
        return new TomcatResourceServlet((HttpContext)contextModel.getHttpContext(), contextModel.getContextName(), alias, name, context);
    }

    @Override
    public void addSecurityConstraintMapping(SecurityConstraintMappingModel secMapModel) {
        LOG.debug("add security contstraint mapping [{}]", (Object)secMapModel);
        Context context = this.findOrCreateContext(secMapModel.getContextModel());
        String mappingMethod = secMapModel.getMapping();
        String constraintName = secMapModel.getConstraintName();
        String url = secMapModel.getUrl();
        String dataConstraint = secMapModel.getDataConstraint();
        List roles = secMapModel.getRoles();
        boolean authentication = secMapModel.isAuthentication();
        SecurityConstraint[] constraints = context.findConstraints();
        SecurityConstraint secConstraint = new SecurityConstraint();
        boolean foundExisting = false;
        for (SecurityConstraint securityConstraint : constraints) {
            if (!securityConstraint.getDisplayName().equalsIgnoreCase(constraintName)) continue;
            secConstraint = securityConstraint;
            foundExisting = true;
        }
        if (!foundExisting) {
            secConstraint.setDisplayName(secMapModel.getConstraintName());
            secConstraint.setAuthConstraint(authentication);
            for (String authRole : roles) {
                secConstraint.addAuthRole(authRole);
            }
            secConstraint.setUserConstraint(dataConstraint);
            context.addConstraint(secConstraint);
        }
        SecurityCollection collection = new SecurityCollection();
        collection.addMethod(mappingMethod);
        collection.addPattern(url);
        secConstraint.addCollection(collection);
    }

    @Override
    public void removeSecurityConstraintMapping(SecurityConstraintMappingModel secMapModel) {
        if (secMapModel == null) {
            return;
        }
        LOG.debug("remove security contstraint mapping [{}]", (Object)secMapModel);
        Context context = this.findOrCreateContext(secMapModel.getContextModel());
        SecurityConstraint toRemove = null;
        for (SecurityConstraint sc : context.findConstraints()) {
            if (!sc.getDisplayName().equalsIgnoreCase(secMapModel.getConstraintName())) continue;
            toRemove = sc;
            break;
        }
        if (toRemove != null) {
            context.removeConstraint(toRemove);
        }
    }

    @Override
    public LifeCycle getContext(ContextModel model) {
        final Context context = this.findOrCreateContext(model);
        return new LifeCycle(){

            public void start() throws Exception {
                ContainerBase host = (ContainerBase)TomcatServerWrapper.this.server.getHost();
                host.setStartChildren(true);
                if (!context.getState().isAvailable()) {
                    LOG.info("server is available, in state {}", (Object)context.getState());
                    context.start();
                }
            }

            public void stop() throws Exception {
                context.stop();
            }
        };
    }

    private void addServletMappings(Context context, String servletName, String[] urlPatterns) {
        NullArgumentException.validateNotNull(urlPatterns, "urlPatterns");
        for (String urlPattern : urlPatterns) {
            context.addServletMappingDecoded(urlPattern, servletName);
        }
    }

    private void addInitParameters(Wrapper wrapper, Map<String, String> initParameters) {
        NullArgumentException.validateNotNull(initParameters, "initParameters");
        NullArgumentException.validateNotNull(wrapper, "wrapper");
        for (Map.Entry<String, String> initParam : initParameters.entrySet()) {
            wrapper.addInitParameter(initParam.getKey(), initParam.getValue());
        }
    }

    private Context findOrCreateContext(Model model) {
        NullArgumentException.validateNotNull(model, "model");
        return this.findOrCreateContext(model.getContextModel());
    }

    private Context findOrCreateContext(ContextModel contextModel) {
        WebContainerContext httpContext = contextModel.getHttpContext();
        Context context = this.contextMap.get(httpContext);
        if (context == null) {
            context = this.server.findContext(contextModel);
        }
        if (context == null) {
            context = this.createContext(contextModel);
        }
        return context;
    }

    private Context createContext(ContextModel contextModel) {
        String authMethod;
        Bundle bundle = contextModel.getBundle();
        BundleContext bundleContext = BundleUtils.getBundleContext(bundle);
        WebContainerContext httpContext = contextModel.getHttpContext();
        Context context = this.server.addContext(contextModel.getContextParams(), this.getContextAttributes(bundleContext), contextModel.getContextName(), contextModel.getHttpContext(), contextModel.getAccessControllerContext(), contextModel.getContainerInitializers(), contextModel.getJettyWebXmlURL(), contextModel.getVirtualHosts(), null, this.server.getBasedir());
        context.setDisplayName(httpContext.getContextId());
        ClassLoader classLoader = contextModel.getClassLoader();
        List bundles = ((ResourceDelegatingBundleClassLoader)classLoader).getBundles();
        ClassLoader parentClassLoader = this.getClass().getClassLoader();
        ResourceDelegatingBundleClassLoader containerSpecificClassLoader = new ResourceDelegatingBundleClassLoader(bundles, parentClassLoader);
        context.setParentClassLoader((ClassLoader)containerSpecificClassLoader);
        URL defaultContextUrl = this.getDefaultContextXml();
        URL configFile = bundle.getEntry("META-INF/context.xml");
        if (defaultContextUrl != null || configFile != null) {
            Digester digester = this.createContextDigester();
            if (defaultContextUrl != null) {
                this.processContextConfig(context, digester, defaultContextUrl);
            }
            if (configFile != null) {
                context.setConfigFile(configFile);
                this.processContextConfig(context, digester, configFile);
            }
        }
        if ((authMethod = contextModel.getAuthMethod()) == null) {
            authMethod = "NONE";
        }
        String realmName = contextModel.getRealmName();
        String loginPage = contextModel.getFormLoginPage();
        String errorPage = contextModel.getFormErrorPage();
        LoginConfig loginConfig = new LoginConfig(authMethod, realmName, loginPage, errorPage);
        context.setLoginConfig(loginConfig);
        LOG.debug("loginConfig: method={} realm={}", (Object)authMethod, (Object)realmName);
        context.getPipeline().addValve((Valve)new ServiceValve((HttpContext)httpContext));
        if (context.getAuthenticator() == null) {
            context.getPipeline().addValve(this.getAuthenticatorValve(authMethod));
        }
        if (contextModel.getContextParams() != null) {
            for (Map.Entry entry : contextModel.getContextParams().entrySet()) {
                context.addParameter((String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.configureJspConfigDescriptor(context, contextModel);
        LifecycleState state = context.getState();
        if (state != LifecycleState.STARTED && state != LifecycleState.STARTING && state != LifecycleState.STARTING_PREP) {
            SessionCookieConfig scc;
            LOG.debug("Registering ServletContext as service. ");
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("osgi.web.symbolicname", bundle.getSymbolicName());
            Dictionary headers = bundle.getHeaders();
            String version = (String)headers.get("Bundle-Version");
            if (version != null && version.length() > 0) {
                ((Dictionary)properties).put("osgi.web.version", version);
            }
            String webContextPath = (String)headers.get(WEB_CONTEXT_PATH);
            String webappContext = (String)headers.get("Webapp-Context");
            ServletContext servletContext = context.getServletContext();
            if ("/".equalsIgnoreCase(context.getPath()) && (webContextPath == null || webappContext == null)) {
                webContextPath = context.getPath();
            }
            if ((scc = servletContext.getSessionCookieConfig()) != null) {
                if (contextModel.getSessionDomain() != null) {
                    scc.setDomain(contextModel.getSessionDomain());
                }
                if (contextModel.getSessionCookie() != null) {
                    scc.setName(contextModel.getSessionCookie());
                    context.setSessionCookieName(contextModel.getSessionCookie());
                }
                if (contextModel.getSessionCookieMaxAge() != null) {
                    scc.setMaxAge(contextModel.getSessionCookieMaxAge().intValue());
                }
                if (contextModel.getSessionCookieHttpOnly() != null) {
                    scc.setHttpOnly(contextModel.getSessionCookieHttpOnly().booleanValue());
                }
                if (contextModel.getSessionCookieSecure() != null) {
                    scc.setSecure(contextModel.getSessionCookieSecure().booleanValue());
                }
            }
            String string = webContextPath = webContextPath != null ? webContextPath : webappContext;
            if (webContextPath != null && !webContextPath.startsWith("/")) {
                webContextPath = "/" + webContextPath;
            }
            if (webContextPath == null) {
                LOG.warn("osgi.web.contextpath couldn't be set, it's not configured. Assuming '/'");
                webContextPath = "/";
            }
            ((Dictionary)properties).put("osgi.web.contextpath", webContextPath);
            ((Dictionary)properties).put("osgi.web.contextname", context.getServletContext().getServletContextName());
            this.servletContextService = bundleContext.registerService(ServletContext.class, (Object)servletContext, properties);
            LOG.debug("ServletContext registered as service. ");
        }
        this.contextMap.put((HttpContext)contextModel.getHttpContext(), context);
        return context;
    }

    private Valve getAuthenticatorValve(String authMethod) {
        String authUpper;
        switch (authUpper = authMethod.toUpperCase(Locale.ROOT)) {
            case "BASIC": {
                return new BasicAuthenticator();
            }
            case "CLIENT-CERT": {
                return new SSLAuthenticator();
            }
            case "DIGEST": {
                return new DigestAuthenticator();
            }
            case "FORM": {
                return new FormAuthenticator();
            }
            case "SPNEGO": {
                return new SpnegoAuthenticator();
            }
            case "NONE": {
                return new NonLoginAuthenticator();
            }
        }
        return this.getAuthenticator(authUpper);
    }

    private Valve getAuthenticator(String method) {
        ServiceLoader<AuthenticatorService> sl = ServiceLoader.load(AuthenticatorService.class, this.getClass().getClassLoader());
        for (AuthenticatorService svc : sl) {
            try {
                Valve auth = (Valve)svc.getAuthenticatorService(method, Valve.class);
                if (auth == null) continue;
                return auth;
            }
            catch (Throwable t) {
                LOG.debug("Unable to load AuthenticatorService for: " + method, t);
            }
        }
        return null;
    }

    private URL getDefaultContextXml() {
        URL defaultContextUrl = this.getClass().getResource("/context.xml");
        File configurationFile = new File(this.server.getConfigurationDir(), "context.xml");
        if (configurationFile.exists()) {
            try {
                defaultContextUrl = configurationFile.toURI().toURL();
            }
            catch (MalformedURLException e) {
                LOG.error("cannot access default context file", (Throwable)e);
            }
        }
        return defaultContextUrl;
    }

    private Digester createContextDigester() {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.setRulesValidation(true);
        HashMap fakeAttributes = new HashMap();
        ArrayList<String> attrs = new ArrayList<String>();
        attrs.add("className");
        fakeAttributes.put(Object.class, attrs);
        digester.setFakeAttributes(fakeAttributes);
        ContextRuleSet contextRuleSet = new ContextRuleSet("", false);
        digester.addRuleSet((RuleSet)contextRuleSet);
        NamingRuleSet namingRuleSet = new NamingRuleSet("Context/");
        digester.addRuleSet((RuleSet)namingRuleSet);
        return digester;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processContextConfig(Context context, Digester digester, URL contextXml) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing context [" + context.getName() + "] configuration file [" + contextXml + "]");
        }
        InputSource source = null;
        InputStream stream = null;
        try {
            source = new InputSource(contextXml.toString());
            URLConnection xmlConn = contextXml.openConnection();
            xmlConn.setUseCaches(false);
            stream = xmlConn.getInputStream();
        }
        catch (Exception e) {
            LOG.error("Cannot read context file", (Throwable)e);
        }
        if (source == null) {
            return;
        }
        try {
            source.setByteStream(stream);
            digester.setClassLoader(this.getClass().getClassLoader());
            digester.setUseContextClassLoader(false);
            digester.push((Object)context.getParent());
            digester.push((Object)context);
            XmlErrorHandler errorHandler = new XmlErrorHandler();
            digester.setErrorHandler((ErrorHandler)errorHandler);
            digester.parse(source);
            if (errorHandler.getWarnings().size() > 0 || errorHandler.getErrors().size() > 0) {
                for (SAXParseException e : errorHandler.getWarnings()) {
                    LOG.warn("Warning in XML processing", (Object)e.getMessage(), (Object)source);
                }
                for (SAXParseException e : errorHandler.getErrors()) {
                    LOG.warn("Error in XML processing", (Object)e.getMessage(), (Object)source);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Successfully processed context [" + context.getName() + "] configuration file [" + contextXml + "]");
            }
        }
        catch (SAXParseException e) {
            LOG.error("Cannot parse config file {}", (Object)context.getName(), (Object)e);
            LOG.error("at {} {}", (Object)("" + e.getLineNumber()), (Object)("" + e.getColumnNumber()));
        }
        catch (Exception e) {
            LOG.error("Cannot parse context {}", (Object)context.getName(), (Object)e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                LOG.error("Cannot close context configuration", (Throwable)e);
            }
        }
    }

    private void configureJspConfigDescriptor(Context context, ContextModel model) {
        Boolean elIgnored = model.getJspElIgnored();
        Boolean isXml = model.getJspIsXml();
        Boolean scriptingInvalid = model.getJspScriptingInvalid();
        ArrayList<JspPropertyGroupDescriptorImpl> jspPropertyGroupDescriptors = null;
        ArrayList<TaglibDescriptorImpl> taglibs = null;
        if (elIgnored != null || isXml != null || scriptingInvalid != null || model.getJspIncludeCodes() != null || model.getJspUrlPatterns() != null || model.getJspIncludePreludes() != null) {
            JspPropertyGroup jspPropertyGroup = new JspPropertyGroup();
            JspPropertyGroupDescriptorImpl jspPropertyGroupDescriptor = new JspPropertyGroupDescriptorImpl(jspPropertyGroup);
            if (jspPropertyGroupDescriptors == null) {
                jspPropertyGroupDescriptors = new ArrayList<JspPropertyGroupDescriptorImpl>();
            }
            jspPropertyGroupDescriptors.add(jspPropertyGroupDescriptor);
            if (model.getJspIncludeCodes() != null) {
                for (String includeCoda : model.getJspIncludeCodes()) {
                    jspPropertyGroup.addIncludeCoda(includeCoda);
                }
            }
            if (model.getJspUrlPatterns() != null) {
                for (String urlPattern : model.getJspUrlPatterns()) {
                    jspPropertyGroup.addUrlPattern(urlPattern);
                }
            }
            if (model.getJspIncludePreludes() != null) {
                for (String prelude : model.getJspIncludePreludes()) {
                    jspPropertyGroup.addIncludePrelude(prelude);
                }
            }
            if (elIgnored != null) {
                jspPropertyGroup.setElIgnored(elIgnored.toString());
            }
            if (isXml != null) {
                jspPropertyGroup.setIsXml(isXml.toString());
            }
            if (scriptingInvalid != null) {
                jspPropertyGroup.setScriptingInvalid(scriptingInvalid.toString());
            }
        }
        if (model.getTagLibLocation() != null || model.getTagLibUri() != null) {
            TaglibDescriptorImpl tagLibDescriptor = new TaglibDescriptorImpl(model.getTagLibLocation(), model.getTagLibUri());
            if (taglibs == null) {
                taglibs = new ArrayList<TaglibDescriptorImpl>();
            }
            taglibs.add(tagLibDescriptor);
        }
        if (jspPropertyGroupDescriptors != null || taglibs != null) {
            JspConfigDescriptorImpl jspConfig = new JspConfigDescriptorImpl(jspPropertyGroupDescriptors, taglibs);
            ((Context)context.getServletContext()).setJspConfigDescriptor((JspConfigDescriptor)jspConfig);
        }
    }

    private Context findContext(ContextModel contextModel) {
        return this.server.findContext(contextModel);
    }

    private Context findContext(Model model) {
        return this.findContext(model.getContextModel());
    }

    private Map<String, Object> getContextAttributes(BundleContext bundleContext) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (this.contextAttributes != null) {
            attributes.putAll(this.contextAttributes);
        }
        attributes.put("osgi-bundlecontext", bundleContext);
        attributes.put("org.springframework.osgi.web.org.osgi.framework.BundleContext", bundleContext);
        return attributes;
    }

    @Override
    public void addWelcomeFiles(WelcomeFileModel model) {
        Context context = this.findOrCreateContext(model.getContextModel());
        for (String welcomeFile : model.getWelcomeFiles()) {
            context.addWelcomeFile(welcomeFile);
        }
    }

    @Override
    public void removeWelcomeFiles(WelcomeFileModel model) {
        Context context = this.findOrCreateContext(model.getContextModel());
        LOG.info("removing welcome files");
        for (String welcomeFile : model.getWelcomeFiles()) {
            context.removeWelcomeFile(welcomeFile);
        }
    }

    private final class FilterLifecycleListener
    implements LifecycleListener {
        private final FilterModel filterModel;
        private final Context context;

        private FilterLifecycleListener(FilterModel filterModel, Context context) {
            this.filterModel = filterModel;
            this.context = context;
        }

        public void lifecycleEvent(LifecycleEvent event) {
            if ("before_start".equalsIgnoreCase(event.getType())) {
                FilterRegistration.Dynamic filterRegistration = null;
                if (this.filterModel.getFilter() != null) {
                    filterRegistration = this.context.getServletContext().addFilter(this.filterModel.getName(), this.filterModel.getFilter());
                } else if (this.filterModel.getFilterClass() != null) {
                    filterRegistration = this.context.getServletContext().addFilter(this.filterModel.getName(), this.filterModel.getFilterClass());
                }
                if (filterRegistration == null && (filterRegistration = (FilterRegistration.Dynamic)this.context.getServletContext().getFilterRegistration(this.filterModel.getName())) == null) {
                    LOG.error("Can't register Filter due to unknown reason!");
                    return;
                }
                filterRegistration.setAsyncSupported(this.filterModel.isAsyncSupported());
                if (this.filterModel.getServletNames() != null && this.filterModel.getServletNames().length > 0) {
                    filterRegistration.addMappingForServletNames(TomcatServerWrapper.this.getDispatcherTypes(this.filterModel), false, this.filterModel.getServletNames());
                } else if (this.filterModel.getUrlPatterns() != null && this.filterModel.getUrlPatterns().length > 0) {
                    filterRegistration.addMappingForUrlPatterns(TomcatServerWrapper.this.getDispatcherTypes(this.filterModel), false, this.filterModel.getUrlPatterns());
                } else {
                    throw new AddFilterException("cannot add filter to the context; at least a not empty list of servlet names or URL patterns in exclusive mode must be provided: " + this.filterModel);
                }
                filterRegistration.setInitParameters(this.filterModel.getInitParams());
            }
        }
    }

    private final class ServletLifecycleListener
    implements LifecycleListener {
        private final Context context;
        private final String servletName;
        private final ServletModel model;

        private ServletLifecycleListener(Context context, String servletName, ServletModel model) {
            this.context = context;
            this.servletName = servletName;
            this.model = model;
        }

        public void lifecycleEvent(LifecycleEvent event) {
            Map servletRegistrations;
            if ("after_start".equalsIgnoreCase(event.getType()) && !(servletRegistrations = this.context.getServletContext().getServletRegistrations()).containsKey(this.servletName)) {
                LOG.debug("need to re-register the servlet ...");
                TomcatServerWrapper.this.createServletWrapper(this.model, this.context, this.servletName);
            }
        }
    }

    private final class SerlvetClassNameLifecycleListener
    implements LifecycleListener {
        private final Context context;
        private final Wrapper sw;
        private final ServletModel model;
        private final String servletName;

        private SerlvetClassNameLifecycleListener(Context context, Wrapper sw, ServletModel model, String servletName) {
            this.context = context;
            this.sw = sw;
            this.model = model;
            this.servletName = servletName;
        }

        public void lifecycleEvent(LifecycleEvent event) {
            Map servletRegistrations;
            if ("after_start".equalsIgnoreCase(event.getType()) && !(servletRegistrations = this.context.getServletContext().getServletRegistrations()).containsKey(this.servletName)) {
                LOG.debug("need to re-register the servlet ...");
                this.sw.setServletClass(this.model.getServletClass().getName());
                TomcatServerWrapper.this.addServletWrapper(this.sw, this.servletName, this.context, this.model);
            }
        }
    }

    private final class WrappedServletLifecycleListener
    implements LifecycleListener {
        private final Context context;
        private final String servletName;
        private final ServletModel model;

        private WrappedServletLifecycleListener(Context context, String servletName, ServletModel model) {
            this.context = context;
            this.servletName = servletName;
            this.model = model;
        }

        public void lifecycleEvent(LifecycleEvent event) {
            Map servletRegistrations;
            if ("before_start".equalsIgnoreCase(event.getType()) && !(servletRegistrations = this.context.getServletContext().getServletRegistrations()).containsKey(this.servletName)) {
                LOG.debug("need to re-register the servlet ...");
                TomcatServerWrapper.this.createServletWrapper(this.model, this.context, this.servletName);
            }
        }
    }
}

