/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.codec;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.data.api.codec.BooleanCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.TypeDefinitionAwareCodec;
import org.opendaylight.yangtools.yang.model.api.type.BooleanTypeDefinition;

@Beta
public final class BooleanStringCodec
extends TypeDefinitionAwareCodec<Boolean, BooleanTypeDefinition>
implements BooleanCodec<String> {
    private BooleanStringCodec(Optional<BooleanTypeDefinition> typeDef) {
        super(typeDef, Boolean.class);
    }

    @Override
    public String serialize(Boolean data) {
        return Objects.toString(data, "");
    }

    @Override
    public Boolean deserialize(String stringRepresentation) {
        if (stringRepresentation == null) {
            return null;
        }
        Preconditions.checkArgument(("true".equalsIgnoreCase(stringRepresentation) || "false".equalsIgnoreCase(stringRepresentation) ? 1 : 0) != 0, (String)"Invalid value '%s' for boolean type. Allowed values are true and false", (Object)stringRepresentation);
        return Boolean.valueOf(stringRepresentation);
    }

    public static BooleanStringCodec from(BooleanTypeDefinition normalizedType) {
        return new BooleanStringCodec(Optional.of(normalizedType));
    }
}

