/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.codec;

import java.util.Optional;
import java.util.regex.Pattern;
import org.opendaylight.yangtools.yang.model.api.type.ModifierKind;
import org.opendaylight.yangtools.yang.model.api.type.PatternConstraint;

class CompiledPatternContext {
    private final Pattern pattern;
    private final String errorMessage;
    private final String regEx;
    private final boolean invert;

    CompiledPatternContext(PatternConstraint yangConstraint) {
        String regularExpr = yangConstraint.getRegularExpressionString();
        this.pattern = regularExpr.startsWith("^") && regularExpr.endsWith("$") ? Pattern.compile(regularExpr) : Pattern.compile(yangConstraint.getJavaPatternString());
        this.errorMessage = yangConstraint.getErrorMessage().orElse(null);
        this.regEx = this.errorMessage == null ? yangConstraint.getRegularExpressionString() : null;
        Optional optModifier = yangConstraint.getModifier();
        if (optModifier.isPresent()) {
            ModifierKind modifier = (ModifierKind)optModifier.get();
            switch (modifier) {
                case INVERT_MATCH: {
                    this.invert = true;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled modifier " + modifier);
                }
            }
        } else {
            this.invert = false;
        }
    }

    void validate(String str) {
        if (this.pattern.matcher(str).matches() == this.invert) {
            if (this.errorMessage != null) {
                throw new IllegalArgumentException(this.errorMessage);
            }
            throw new IllegalArgumentException("Value '" + str + "' " + (this.invert ? "matches" : "does not match") + " regular expression '" + this.regEx + "'");
        }
    }
}

