/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.codec;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.data.api.codec.EnumCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.TypeDefinitionAwareCodec;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;

@Beta
public final class EnumStringCodec
extends TypeDefinitionAwareCodec<String, EnumTypeDefinition>
implements EnumCodec<String> {
    private final ImmutableMap<String, String> values;

    private EnumStringCodec(Optional<EnumTypeDefinition> typeDef) {
        super(typeDef, String.class);
        if (typeDef.isPresent()) {
            ImmutableMap.Builder b = ImmutableMap.builder();
            for (EnumTypeDefinition.EnumPair pair : typeDef.get().getValues()) {
                String v = pair.getName().intern();
                b.put((Object)v, (Object)v);
            }
            this.values = b.build();
        } else {
            this.values = null;
        }
    }

    public static EnumStringCodec from(EnumTypeDefinition normalizedType) {
        return new EnumStringCodec(Optional.of(normalizedType));
    }

    @Override
    public String deserialize(String stringRepresentation) {
        if (this.values == null) {
            return stringRepresentation;
        }
        String result = (String)this.values.get((Object)stringRepresentation);
        Preconditions.checkArgument((result != null ? 1 : 0) != 0, (String)"Invalid value '%s' for enum type. Allowed values are: %s", (Object)stringRepresentation, (Object)this.values.keySet());
        return result;
    }

    @Override
    public String serialize(String data) {
        return Objects.toString(data, "");
    }
}

