/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.codec;

import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.data.api.codec.Uint16Codec;
import org.opendaylight.yangtools.yang.data.impl.codec.AbstractIntegerStringCodec;
import org.opendaylight.yangtools.yang.model.api.type.Uint16TypeDefinition;

final class Uint16StringCodec
extends AbstractIntegerStringCodec<Integer, Uint16TypeDefinition>
implements Uint16Codec<String> {
    Uint16StringCodec(Optional<Uint16TypeDefinition> typeDef) {
        super(typeDef, Uint16StringCodec.extractRange(typeDef.orElse(null)), Integer.class);
    }

    @Override
    Integer deserialize(String stringRepresentation, int base) {
        return Integer.valueOf(stringRepresentation, base);
    }

    @Override
    public String serialize(Integer data) {
        return Objects.toString(data, "");
    }
}

