/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.codec;

import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.data.api.codec.Uint64Codec;
import org.opendaylight.yangtools.yang.data.impl.codec.AbstractIntegerStringCodec;
import org.opendaylight.yangtools.yang.model.api.type.Uint64TypeDefinition;

final class Uint64StringCodec
extends AbstractIntegerStringCodec<BigInteger, Uint64TypeDefinition>
implements Uint64Codec<String> {
    Uint64StringCodec(Optional<Uint64TypeDefinition> typeDef) {
        super(typeDef, Uint64StringCodec.extractRange(typeDef.orElse(null)), BigInteger.class);
    }

    @Override
    BigInteger deserialize(String stringRepresentation, int base) {
        return new BigInteger(stringRepresentation, base);
    }

    @Override
    public String serialize(BigInteger data) {
        return Objects.toString(data, "");
    }
}

