/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.leafref;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.opendaylight.yangtools.yang.data.impl.leafref.LeafRefContext;
import org.opendaylight.yangtools.yang.data.impl.leafref.LeafRefContextBuilder;
import org.opendaylight.yangtools.yang.data.impl.leafref.LeafRefPath;
import org.opendaylight.yangtools.yang.data.impl.leafref.LeafRefPathParserImpl;
import org.opendaylight.yangtools.yang.data.impl.leafref.LeafRefUtils;
import org.opendaylight.yangtools.yang.data.impl.leafref.LeafRefYangSyntaxErrorException;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.TypedDataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;

final class LeafRefContextTreeBuilder {
    private final List<LeafRefContext> leafRefs = new LinkedList<LeafRefContext>();
    private final SchemaContext schemaContext;

    LeafRefContextTreeBuilder(SchemaContext schemaContext) {
        this.schemaContext = schemaContext;
    }

    LeafRefContext buildLeafRefContextTree() throws LeafRefYangSyntaxErrorException {
        LeafRefContextBuilder rootBuilder = new LeafRefContextBuilder(this.schemaContext.getQName(), this.schemaContext.getPath(), this.schemaContext);
        Set modules = this.schemaContext.getModules();
        for (Module module : modules) {
            for (DataSchemaNode childNode : module.getChildNodes()) {
                LeafRefContext childLeafRefContext = this.buildLeafRefContextReferencingTree(childNode, module);
                if (!childLeafRefContext.hasReferencingChild() && !childLeafRefContext.isReferencing()) continue;
                rootBuilder.addReferencingChild(childLeafRefContext, childLeafRefContext.getNodeName());
            }
        }
        for (Module module : modules) {
            Collection childNodes = module.getChildNodes();
            for (DataSchemaNode childNode : childNodes) {
                LeafRefContext childLeafRefContext = this.buildLeafRefContextReferencedByTree(childNode, module);
                if (!childLeafRefContext.hasReferencedChild() && !childLeafRefContext.isReferenced()) continue;
                rootBuilder.addReferencedByChild(childLeafRefContext, childLeafRefContext.getNodeName());
            }
        }
        return rootBuilder.build();
    }

    private LeafRefContext buildLeafRefContextReferencingTree(DataSchemaNode node, Module currentModule) throws LeafRefYangSyntaxErrorException {
        TypeDefinition type;
        LeafRefContextBuilder currentLeafRefContextBuilder = new LeafRefContextBuilder(node.getQName(), node.getPath(), this.schemaContext);
        if (node instanceof DataNodeContainer) {
            for (DataSchemaNode childNode : ((DataNodeContainer)node).getChildNodes()) {
                LeafRefContext childLeafRefContext = this.buildLeafRefContextReferencingTree(childNode, currentModule);
                if (!childLeafRefContext.hasReferencingChild() && !childLeafRefContext.isReferencing()) continue;
                currentLeafRefContextBuilder.addReferencingChild(childLeafRefContext, childLeafRefContext.getNodeName());
            }
        } else if (node instanceof ChoiceSchemaNode) {
            for (CaseSchemaNode caseNode : ((ChoiceSchemaNode)node).getCases().values()) {
                LeafRefContext childLeafRefContext = this.buildLeafRefContextReferencingTree((DataSchemaNode)caseNode, currentModule);
                if (!childLeafRefContext.hasReferencingChild() && !childLeafRefContext.isReferencing()) continue;
                currentLeafRefContextBuilder.addReferencingChild(childLeafRefContext, childLeafRefContext.getNodeName());
            }
        } else if (node instanceof TypedDataSchemaNode && (type = ((TypedDataSchemaNode)node).getType()) instanceof LeafrefTypeDefinition) {
            LeafrefTypeDefinition leafrefType = (LeafrefTypeDefinition)type;
            String leafRefPathString = leafrefType.getPathStatement().toString();
            LeafRefPathParserImpl leafRefPathParser = new LeafRefPathParserImpl(this.schemaContext, (Module)Preconditions.checkNotNull((Object)this.getBaseTypeModule(leafrefType), (String)"Unable to find base module for leafref %s", (Object)node), (SchemaNode)node);
            LeafRefPath leafRefPath = leafRefPathParser.parseLeafRefPath(leafRefPathString);
            currentLeafRefContextBuilder.setLeafRefTargetPathString(leafRefPathString);
            currentLeafRefContextBuilder.setReferencing(true);
            currentLeafRefContextBuilder.setLeafRefTargetPath(leafRefPath);
            LeafRefContext currentLeafRefContext = currentLeafRefContextBuilder.build();
            this.leafRefs.add(currentLeafRefContext);
            return currentLeafRefContext;
        }
        return currentLeafRefContextBuilder.build();
    }

    private Module getBaseTypeModule(LeafrefTypeDefinition leafrefType) {
        LeafrefTypeDefinition baseLeafRefType = leafrefType;
        while (baseLeafRefType.getBaseType() != null) {
            baseLeafRefType = (LeafrefTypeDefinition)baseLeafRefType.getBaseType();
        }
        return this.schemaContext.findModule(baseLeafRefType.getQName().getModule()).orElse(null);
    }

    private LeafRefContext buildLeafRefContextReferencedByTree(DataSchemaNode node, Module currentModule) throws LeafRefYangSyntaxErrorException {
        LeafRefContextBuilder currentLeafRefContextBuilder;
        block4: {
            List<LeafRefContext> foundLeafRefs;
            block5: {
                block3: {
                    currentLeafRefContextBuilder = new LeafRefContextBuilder(node.getQName(), node.getPath(), this.schemaContext);
                    if (!(node instanceof DataNodeContainer)) break block3;
                    for (DataSchemaNode childNode : ((DataNodeContainer)node).getChildNodes()) {
                        LeafRefContext childLeafRefContext = this.buildLeafRefContextReferencedByTree(childNode, currentModule);
                        if (!childLeafRefContext.hasReferencedChild() && !childLeafRefContext.isReferenced()) continue;
                        currentLeafRefContextBuilder.addReferencedByChild(childLeafRefContext, childLeafRefContext.getNodeName());
                    }
                    break block4;
                }
                if (!(node instanceof ChoiceSchemaNode)) break block5;
                for (CaseSchemaNode caseNode : ((ChoiceSchemaNode)node).getCases().values()) {
                    LeafRefContext childLeafRefContext = this.buildLeafRefContextReferencedByTree((DataSchemaNode)caseNode, currentModule);
                    if (!childLeafRefContext.hasReferencedChild() && !childLeafRefContext.isReferenced()) continue;
                    currentLeafRefContextBuilder.addReferencedByChild(childLeafRefContext, childLeafRefContext.getNodeName());
                }
                break block4;
            }
            if (!(node instanceof LeafSchemaNode) && !(node instanceof LeafListSchemaNode) || (foundLeafRefs = this.getLeafRefsFor(node, currentModule)).isEmpty()) break block4;
            currentLeafRefContextBuilder.setReferencedBy(true);
            for (LeafRefContext leafRef : foundLeafRefs) {
                currentLeafRefContextBuilder.addReferencedByLeafRefCtx(leafRef.getNodeName(), leafRef);
            }
        }
        return currentLeafRefContextBuilder.build();
    }

    private List<LeafRefContext> getLeafRefsFor(DataSchemaNode node, Module module) {
        LeafRefPath nodeXPath = LeafRefUtils.schemaPathToLeafRefPath(node.getPath(), module);
        LinkedList<LeafRefContext> foundLeafRefs = new LinkedList<LeafRefContext>();
        for (LeafRefContext leafref : this.leafRefs) {
            LeafRefPath leafRefTargetPath = leafref.getAbsoluteLeafRefTargetPath();
            if (!leafRefTargetPath.equals(nodeXPath)) continue;
            foundLeafRefs.add(leafref);
        }
        return foundLeafRefs;
    }
}

