/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.leafref;

import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.opendaylight.yangtools.yang.data.impl.leafref.LeafRefPathSyntaxErrorException;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LeafRefPathErrorListener
extends BaseErrorListener {
    private static final Logger LOG = LoggerFactory.getLogger(LeafRefPathErrorListener.class);
    private final List<LeafRefPathSyntaxErrorException> exceptions = new ArrayList<LeafRefPathSyntaxErrorException>(1);
    private final Module module;

    LeafRefPathErrorListener(Module module) {
        this.module = module;
    }

    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        LOG.debug("Syntax error in module {} at {}:{}: {}", new Object[]{this.module.getName(), line, charPositionInLine, msg, e});
        this.exceptions.add(new LeafRefPathSyntaxErrorException(this.module.getName(), line, charPositionInLine, msg, (Throwable)e));
    }

    public void validate() throws LeafRefPathSyntaxErrorException {
        if (this.exceptions.isEmpty()) {
            return;
        }
        if (this.exceptions.size() == 1) {
            throw this.exceptions.get(0);
        }
        StringBuilder sb = new StringBuilder();
        String exceptionModule = null;
        boolean first = true;
        for (LeafRefPathSyntaxErrorException e : this.exceptions) {
            if (exceptionModule == null) {
                exceptionModule = e.getModule();
            }
            if (first) {
                first = false;
            } else {
                sb.append('\n');
            }
            sb.append(e.getFormattedMessage());
        }
        throw new LeafRefPathSyntaxErrorException(exceptionModule, 0, 0, sb.toString());
    }
}

