/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.leafref;

import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.impl.leafref.LeafRefPath;
import org.opendaylight.yangtools.yang.data.impl.leafref.QNameWithPredicate;
import org.opendaylight.yangtools.yang.data.impl.leafref.SimpleQNameWithPredicate;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

public final class LeafRefUtils {
    private LeafRefUtils() {
        throw new UnsupportedOperationException();
    }

    public static LeafRefPath createAbsoluteLeafRefPath(LeafRefPath leafRefPath, SchemaPath contextNodeSchemaPath, Module module) {
        if (leafRefPath.isAbsolute()) {
            return leafRefPath;
        }
        Deque<QNameWithPredicate> absoluteLeafRefTargetPathList = LeafRefUtils.schemaPathToXPathQNames(contextNodeSchemaPath, module);
        for (QNameWithPredicate qname : leafRefPath.getPathFromRoot()) {
            if (qname.equals(QNameWithPredicate.UP_PARENT)) {
                absoluteLeafRefTargetPathList.removeLast();
                continue;
            }
            absoluteLeafRefTargetPathList.add(qname);
        }
        return LeafRefPath.create(absoluteLeafRefTargetPathList, true);
    }

    private static Deque<QNameWithPredicate> schemaPathToXPathQNames(SchemaPath nodePath, Module module) {
        LinkedList<QNameWithPredicate> xpath = new LinkedList<QNameWithPredicate>();
        Iterator nodePathIterator = nodePath.getPathFromRoot().iterator();
        Module currenDataNodeContainer = module;
        while (nodePathIterator.hasNext()) {
            QName qname = (QName)nodePathIterator.next();
            DataSchemaNode child = currenDataNodeContainer.getDataChildByName(qname);
            if (child instanceof DataNodeContainer) {
                if (!(child instanceof CaseSchemaNode)) {
                    xpath.add(new SimpleQNameWithPredicate(qname));
                }
                currenDataNodeContainer = (DataNodeContainer)child;
                continue;
            }
            if (child instanceof ChoiceSchemaNode) {
                if (!nodePathIterator.hasNext()) break;
                currenDataNodeContainer = (DataNodeContainer)((ChoiceSchemaNode)child).getCases().get(nodePathIterator.next());
                continue;
            }
            if (child instanceof LeafSchemaNode || child instanceof LeafListSchemaNode) {
                xpath.add(new SimpleQNameWithPredicate(qname));
                break;
            }
            if (child == null) {
                throw new IllegalArgumentException("No child " + qname + " found in node container " + currenDataNodeContainer + " in module " + module.getName());
            }
            throw new IllegalStateException("Illegal schema node type in the path: " + child.getClass());
        }
        return xpath;
    }

    public static LeafRefPath schemaPathToLeafRefPath(SchemaPath nodePath, Module module) {
        return LeafRefPath.create(LeafRefUtils.schemaPathToXPathQNames(nodePath, module), true);
    }
}

