/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.leafref;

import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.impl.leafref.LeafRefPath;
import org.opendaylight.yangtools.yang.data.impl.leafref.QNamePredicate;
import org.opendaylight.yangtools.yang.data.impl.leafref.QNamePredicateImpl;
import org.opendaylight.yangtools.yang.data.impl.leafref.QNameWithPredicate;

class QNamePredicateBuilder
implements Builder<QNamePredicate> {
    private QName identifier;
    private LeafRefPath pathKeyExpression;

    QNamePredicateBuilder() {
    }

    QNamePredicateBuilder(QName identifier, LeafRefPath pathKeyExpression) {
        this.identifier = identifier;
        this.pathKeyExpression = pathKeyExpression;
    }

    public QName getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(QName identifier) {
        this.identifier = identifier;
    }

    public LeafRefPath getPathKeyExpression() {
        return this.pathKeyExpression;
    }

    public void setPathKeyExpression(LeafRefPath pathKeyExpression) {
        this.pathKeyExpression = pathKeyExpression;
    }

    public QNamePredicate build() {
        return new QNamePredicateImpl(this.identifier, this.pathKeyExpression);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(this.identifier);
        sb.append("=current()");
        for (QNameWithPredicate qname : this.pathKeyExpression.getPathFromRoot()) {
            sb.append('/').append(qname);
        }
        sb.append(']');
        return sb.toString();
    }
}

