/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.ModifyAction;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AnyXmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListNode;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.InstanceIdToCompositeNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.InstanceIdToSimpleNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.AttributesBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.CollectionNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.NormalizedNodeBuilder;
import org.opendaylight.yangtools.yang.model.api.AnyXmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationTarget;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

abstract class InstanceIdToNodes<T extends YangInstanceIdentifier.PathArgument>
implements Identifiable<T> {
    private final T identifier;

    InstanceIdToNodes(T identifier) {
        this.identifier = identifier;
    }

    public final T getIdentifier() {
        return this.identifier;
    }

    abstract InstanceIdToNodes<?> getChild(YangInstanceIdentifier.PathArgument var1);

    abstract @NonNull NormalizedNode<?, ?> create(YangInstanceIdentifier.PathArgument var1, Iterator<YangInstanceIdentifier.PathArgument> var2, Optional<NormalizedNode<?, ?>> var3, Optional<Map.Entry<QName, ModifyAction>> var4);

    abstract boolean isMixin();

    static void addModifyOpIfPresent(Optional<Map.Entry<QName, ModifyAction>> operation, AttributesBuilder<?> builder) {
        if (operation.isPresent()) {
            Map.Entry<QName, ModifyAction> entry = operation.get();
            builder.withAttributes((Map<QName, String>)ImmutableMap.of((Object)entry.getKey(), (Object)entry.getValue().name().toLowerCase()));
        }
    }

    private static Optional<DataSchemaNode> findChildSchemaNode(DataNodeContainer parent, QName child) {
        DataSchemaNode potential = parent.getDataChildByName(child);
        if (potential == null) {
            potential = InstanceIdToNodes.findChoice(Iterables.filter((Iterable)parent.getChildNodes(), ChoiceSchemaNode.class), child);
        }
        return Optional.ofNullable(potential);
    }

    static InstanceIdToNodes<?> fromSchemaAndQNameChecked(DataNodeContainer schema, QName child) {
        Optional<DataSchemaNode> potential = InstanceIdToNodes.findChildSchemaNode(schema, child);
        Preconditions.checkArgument((boolean)potential.isPresent(), (String)"Supplied QName %s is not valid according to schema %s, potential children nodes: %s", (Object)child, (Object)schema, (Object)schema.getChildNodes());
        DataSchemaNode result = potential.get();
        if (schema instanceof DataSchemaNode && result.isAugmenting()) {
            return InstanceIdToNodes.fromAugmentation(schema, (AugmentationTarget)schema, result);
        }
        return InstanceIdToNodes.fromDataSchemaNode(result);
    }

    private static ChoiceSchemaNode findChoice(Iterable<ChoiceSchemaNode> choices, QName child) {
        for (ChoiceSchemaNode choice : choices) {
            for (CaseSchemaNode caze : choice.getCases().values()) {
                if (!InstanceIdToNodes.findChildSchemaNode((DataNodeContainer)caze, child).isPresent()) continue;
                return choice;
            }
        }
        return null;
    }

    private static InstanceIdToNodes<?> fromAugmentation(DataNodeContainer parent, AugmentationTarget parentAug, DataSchemaNode child) {
        for (AugmentationSchemaNode aug : parentAug.getAvailableAugmentations()) {
            DataSchemaNode potential = aug.getDataChildByName(child.getQName());
            if (potential == null) continue;
            return new InstanceIdToCompositeNodes.AugmentationNormalization(aug, parent);
        }
        return InstanceIdToNodes.fromDataSchemaNode(child);
    }

    static InstanceIdToNodes<?> fromDataSchemaNode(DataSchemaNode potential) {
        if (potential instanceof ContainerSchemaNode) {
            return new InstanceIdToCompositeNodes.ContainerTransformation((ContainerSchemaNode)potential);
        }
        if (potential instanceof ListSchemaNode) {
            return InstanceIdToNodes.fromListSchemaNode((ListSchemaNode)potential);
        }
        if (potential instanceof LeafSchemaNode) {
            return new InstanceIdToSimpleNodes.LeafNormalization((LeafSchemaNode)potential);
        }
        if (potential instanceof ChoiceSchemaNode) {
            return new InstanceIdToCompositeNodes.ChoiceNodeNormalization((ChoiceSchemaNode)potential);
        }
        if (potential instanceof LeafListSchemaNode) {
            return InstanceIdToNodes.fromLeafListSchemaNode((LeafListSchemaNode)potential);
        }
        if (potential instanceof AnyXmlSchemaNode) {
            return new AnyXmlNormalization((AnyXmlSchemaNode)potential);
        }
        return null;
    }

    private static InstanceIdToNodes<?> fromListSchemaNode(ListSchemaNode potential) {
        List keyDefinition = potential.getKeyDefinition();
        if (keyDefinition == null || keyDefinition.isEmpty()) {
            return new UnkeyedListMixinNormalization(potential);
        }
        return potential.isUserOrdered() ? new InstanceIdToCompositeNodes.OrderedMapMixinNormalization(potential) : new InstanceIdToCompositeNodes.UnorderedMapMixinNormalization(potential);
    }

    private static InstanceIdToNodes<?> fromLeafListSchemaNode(LeafListSchemaNode potential) {
        return potential.isUserOrdered() ? new InstanceIdToCompositeNodes.OrderedLeafListMixinNormalization(potential) : new InstanceIdToCompositeNodes.UnorderedLeafListMixinNormalization(potential);
    }

    private static final class AnyXmlNormalization
    extends InstanceIdToNodes<YangInstanceIdentifier.NodeIdentifier> {
        AnyXmlNormalization(AnyXmlSchemaNode schema) {
            super(YangInstanceIdentifier.NodeIdentifier.create((QName)schema.getQName()));
        }

        @Override
        InstanceIdToNodes<?> getChild(YangInstanceIdentifier.PathArgument child) {
            return null;
        }

        @Override
        NormalizedNode<?, ?> create(YangInstanceIdentifier.PathArgument first, Iterator<YangInstanceIdentifier.PathArgument> others, Optional<NormalizedNode<?, ?>> deepestChild, Optional<Map.Entry<QName, ModifyAction>> operation) {
            NormalizedNodeBuilder builder = Builders.anyXmlBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)((InstanceIdToNodes)this).getIdentifier());
            if (deepestChild.isPresent()) {
                NormalizedNode<?, ?> child = deepestChild.get();
                Preconditions.checkState((boolean)(child instanceof AnyXmlNode));
                builder.withValue(((AnyXmlNode)child).getValue());
            }
            AnyXmlNormalization.addModifyOpIfPresent(operation, builder);
            return builder.build();
        }

        @Override
        boolean isMixin() {
            return false;
        }
    }

    private static final class UnkeyedListMixinNormalization
    extends InstanceIdToCompositeNodes<YangInstanceIdentifier.NodeIdentifier> {
        private final InstanceIdToCompositeNodes.UnkeyedListItemNormalization innerNode;

        UnkeyedListMixinNormalization(ListSchemaNode list) {
            super(YangInstanceIdentifier.NodeIdentifier.create((QName)list.getQName()));
            this.innerNode = new InstanceIdToCompositeNodes.UnkeyedListItemNormalization(list);
        }

        CollectionNodeBuilder<UnkeyedListEntryNode, UnkeyedListNode> createBuilder(YangInstanceIdentifier.PathArgument compositeNode) {
            return Builders.unkeyedListBuilder().withNodeIdentifier((YangInstanceIdentifier.NodeIdentifier)((InstanceIdToNodes)this).getIdentifier());
        }

        @Override
        InstanceIdToNodes<?> getChild(YangInstanceIdentifier.PathArgument child) {
            return child.getNodeType().equals((Object)((YangInstanceIdentifier.NodeIdentifier)((InstanceIdToNodes)this).getIdentifier()).getNodeType()) ? this.innerNode : null;
        }

        @Override
        boolean isMixin() {
            return true;
        }
    }
}

