/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.ModifyAction;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.InstanceIdToNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.NormalizedNodeAttrBuilder;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;

abstract class InstanceIdToSimpleNodes<T extends YangInstanceIdentifier.PathArgument>
extends InstanceIdToNodes<T> {
    InstanceIdToSimpleNodes(T identifier) {
        super(identifier);
    }

    @Override
    final NormalizedNode<?, ?> create(YangInstanceIdentifier.PathArgument first, Iterator<YangInstanceIdentifier.PathArgument> others, Optional<NormalizedNode<?, ?>> deepestChild, Optional<Map.Entry<QName, ModifyAction>> operation) {
        NormalizedNodeAttrBuilder<YangInstanceIdentifier.PathArgument, Object, NormalizedNode<YangInstanceIdentifier.PathArgument, Object>> builder = this.getBuilder(first);
        if (deepestChild.isPresent()) {
            builder.withValue(deepestChild.get().getValue());
        }
        InstanceIdToSimpleNodes.addModifyOpIfPresent(operation, builder);
        return builder.build();
    }

    @Override
    final InstanceIdToNodes<?> getChild(YangInstanceIdentifier.PathArgument child) {
        return null;
    }

    @Override
    final boolean isMixin() {
        return false;
    }

    abstract NormalizedNodeAttrBuilder<? extends YangInstanceIdentifier.PathArgument, Object, ? extends NormalizedNode<? extends YangInstanceIdentifier.PathArgument, Object>> getBuilder(YangInstanceIdentifier.PathArgument var1);

    static final class LeafListEntryNormalization
    extends InstanceIdToSimpleNodes<YangInstanceIdentifier.NodeWithValue> {
        LeafListEntryNormalization(LeafListSchemaNode potential) {
            super(new YangInstanceIdentifier.NodeWithValue(potential.getQName(), null));
        }

        @Override
        NormalizedNodeAttrBuilder<YangInstanceIdentifier.NodeWithValue, Object, LeafSetEntryNode<Object>> getBuilder(YangInstanceIdentifier.PathArgument node) {
            Preconditions.checkArgument((boolean)(node instanceof YangInstanceIdentifier.NodeWithValue));
            return Builders.leafSetEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)((YangInstanceIdentifier.NodeWithValue)node)).withValue(((YangInstanceIdentifier.NodeWithValue)node).getValue());
        }
    }

    static final class LeafNormalization
    extends InstanceIdToSimpleNodes<YangInstanceIdentifier.NodeIdentifier> {
        LeafNormalization(LeafSchemaNode potential) {
            super(new YangInstanceIdentifier.NodeIdentifier(potential.getQName()));
        }

        @Override
        NormalizedNodeAttrBuilder<YangInstanceIdentifier.NodeIdentifier, Object, LeafNode<Object>> getBuilder(YangInstanceIdentifier.PathArgument node) {
            return Builders.leafBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)this.getIdentifier());
        }
    }
}

