/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.builder.impl;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yangtools.util.ModifiableMapPhase;
import org.opendaylight.yangtools.util.UnmodifiableMapPhase;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.DataContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.NormalizedNodeContainerBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.nodes.AbstractImmutableDataContainerNode;
import org.opendaylight.yangtools.yang.data.impl.schema.nodes.CloneableMap;

abstract class AbstractImmutableDataContainerNodeBuilder<I extends YangInstanceIdentifier.PathArgument, R extends DataContainerNode<I>>
implements DataContainerNodeBuilder<I, R> {
    private static final int DEFAULT_CAPACITY = 4;
    private Map<YangInstanceIdentifier.PathArgument, DataContainerChild<? extends YangInstanceIdentifier.PathArgument, ?>> value;
    private I nodeIdentifier;
    private boolean dirty;

    protected AbstractImmutableDataContainerNodeBuilder() {
        this.value = new HashMap(4);
        this.dirty = false;
    }

    protected AbstractImmutableDataContainerNodeBuilder(int sizeHint) {
        this.value = sizeHint >= 0 ? Maps.newHashMapWithExpectedSize((int)sizeHint) : new HashMap(4);
        this.dirty = false;
    }

    protected AbstractImmutableDataContainerNodeBuilder(AbstractImmutableDataContainerNode<I> node) {
        this.nodeIdentifier = node.getIdentifier();
        this.value = node.getChildren();
        this.dirty = true;
    }

    protected final I getNodeIdentifier() {
        return this.nodeIdentifier;
    }

    protected final DataContainerChild<? extends YangInstanceIdentifier.PathArgument, ?> getChild(YangInstanceIdentifier.PathArgument child) {
        return this.value.get(child);
    }

    protected final Map<YangInstanceIdentifier.PathArgument, DataContainerChild<? extends YangInstanceIdentifier.PathArgument, ?>> buildValue() {
        if (this.value instanceof ModifiableMapPhase) {
            return ((ModifiableMapPhase)this.value).toUnmodifiableMap();
        }
        this.dirty = true;
        return this.value;
    }

    private void checkDirty() {
        if (this.dirty) {
            this.value = this.value instanceof UnmodifiableMapPhase ? ((UnmodifiableMapPhase)this.value).toModifiableMap() : (this.value instanceof CloneableMap ? ((CloneableMap)this.value).createMutableClone() : new HashMap(this.value));
            this.dirty = false;
        }
    }

    @Override
    public DataContainerNodeBuilder<I, R> withValue(Collection<DataContainerChild<? extends YangInstanceIdentifier.PathArgument, ?>> withValue) {
        for (DataContainerChild<YangInstanceIdentifier.PathArgument, ?> dataContainerChild : withValue) {
            this.withChild(dataContainerChild);
        }
        return this;
    }

    @Override
    public DataContainerNodeBuilder<I, R> withChild(DataContainerChild<?, ?> child) {
        this.checkDirty();
        this.value.put(child.getIdentifier(), child);
        return this;
    }

    @Override
    public DataContainerNodeBuilder<I, R> withoutChild(YangInstanceIdentifier.PathArgument key) {
        this.checkDirty();
        this.value.remove(key);
        return this;
    }

    @Override
    public DataContainerNodeBuilder<I, R> withNodeIdentifier(I withNodeIdentifier) {
        this.nodeIdentifier = withNodeIdentifier;
        return this;
    }

    public DataContainerNodeBuilder<I, R> addChild(DataContainerChild<? extends YangInstanceIdentifier.PathArgument, ?> child) {
        return this.withChild(child);
    }

    @Override
    public NormalizedNodeContainerBuilder<I, YangInstanceIdentifier.PathArgument, DataContainerChild<? extends YangInstanceIdentifier.PathArgument, ?>, R> removeChild(YangInstanceIdentifier.PathArgument key) {
        return this.withoutChild(key);
    }
}

