/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateTip;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeTip;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataValidationFailedException;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.TreeNode;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.InMemoryDataTreeCandidate;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.InMemoryDataTreeModification;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.LogicalOperation;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModificationPath;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModifiedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.NoopDataTreeCandidate;

abstract class AbstractDataTreeTip
implements DataTreeTip {
    AbstractDataTreeTip() {
    }

    protected abstract @NonNull TreeNode getTipRoot();

    abstract @NonNull YangInstanceIdentifier getRootPath();

    public final void validate(DataTreeModification modification) throws DataValidationFailedException {
        InMemoryDataTreeModification m = AbstractDataTreeTip.checkedCast(modification);
        Preconditions.checkArgument((boolean)m.isSealed(), (String)"Attempted to verify unsealed modification %s", (Object)m);
        m.getStrategy().checkApplicable(new ModificationPath(this.getRootPath()), m.getRootModification(), Optional.of(this.getTipRoot()), m.getVersion());
    }

    public final DataTreeCandidateTip prepare(DataTreeModification modification) {
        InMemoryDataTreeModification m = AbstractDataTreeTip.checkedCast(modification);
        Preconditions.checkArgument((boolean)m.isSealed(), (String)"Attempted to prepare unsealed modification %s", (Object)m);
        ModifiedNode root = m.getRootModification();
        TreeNode currentRoot = this.getTipRoot();
        if (root.getOperation() == LogicalOperation.NONE) {
            return new NoopDataTreeCandidate(YangInstanceIdentifier.EMPTY, root, currentRoot);
        }
        Optional<TreeNode> newRoot = m.getStrategy().apply(m.getRootModification(), Optional.of(currentRoot), m.getVersion());
        Preconditions.checkState((boolean)newRoot.isPresent(), (String)"Apply strategy failed to produce root node for modification %s", (Object)modification);
        return new InMemoryDataTreeCandidate(YangInstanceIdentifier.EMPTY, root, currentRoot, newRoot.get());
    }

    private static InMemoryDataTreeModification checkedCast(DataTreeModification mod) {
        Preconditions.checkArgument((boolean)(mod instanceof InMemoryDataTreeModification), (String)"Invalid modification class %s", mod.getClass());
        return (InMemoryDataTreeModification)mod;
    }
}

