/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.AbstractNodeContainerModificationStrategy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.NormalizedNodeContainerSupport;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.SchemaAwareApplyOperation;
import org.opendaylight.yangtools.yang.model.api.AugmentationTarget;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DataNodeContainerModificationStrategy<T extends DataNodeContainer & DocumentedNode.WithStatus>
extends AbstractNodeContainerModificationStrategy.Visible<T> {
    private static final Logger LOG = LoggerFactory.getLogger(DataNodeContainerModificationStrategy.class);
    private final @NonNull DataTreeConfiguration treeConfig;
    private static final AtomicReferenceFieldUpdater<DataNodeContainerModificationStrategy, ImmutableMap> UPDATER = AtomicReferenceFieldUpdater.newUpdater(DataNodeContainerModificationStrategy.class, ImmutableMap.class, "children");
    private volatile ImmutableMap<YangInstanceIdentifier.PathArgument, ModificationApplyOperation> children = ImmutableMap.of();

    DataNodeContainerModificationStrategy(NormalizedNodeContainerSupport<?, ?> support, T schema, DataTreeConfiguration treeConfig) {
        super(support, treeConfig, (DocumentedNode.WithStatus)schema);
        this.treeConfig = Objects.requireNonNull(treeConfig, "treeConfig");
    }

    @Override
    public final Optional<ModificationApplyOperation> getChild(YangInstanceIdentifier.PathArgument identifier) {
        ImmutableMap<YangInstanceIdentifier.PathArgument, ModificationApplyOperation> local = this.children;
        ModificationApplyOperation existing = (ModificationApplyOperation)local.get((Object)identifier);
        if (existing != null) {
            return Optional.of(existing);
        }
        ModificationApplyOperation childOperation = this.resolveChild(identifier);
        return childOperation != null ? this.appendChild(local, identifier, childOperation) : Optional.empty();
    }

    private ModificationApplyOperation resolveChild(YangInstanceIdentifier.PathArgument identifier) {
        DataNodeContainer schema = (DataNodeContainer)this.getSchema();
        if (identifier instanceof YangInstanceIdentifier.AugmentationIdentifier && schema instanceof AugmentationTarget) {
            return SchemaAwareApplyOperation.from(schema, (AugmentationTarget)schema, (YangInstanceIdentifier.AugmentationIdentifier)identifier, this.treeConfig);
        }
        QName qname = identifier.getNodeType();
        Optional child = schema.findDataChildByName(qname);
        if (!child.isPresent()) {
            LOG.trace("Child {} not present in container schema {} children {}", new Object[]{identifier, this, schema.getChildNodes()});
            return null;
        }
        try {
            return SchemaAwareApplyOperation.from((DataSchemaNode)child.get(), this.treeConfig);
        }
        catch (IllegalArgumentException e) {
            LOG.trace("Failed to instantiate child {} in container schema {} children {}", new Object[]{identifier, this, schema.getChildNodes(), e});
            return null;
        }
    }

    private Optional<ModificationApplyOperation> appendChild(ImmutableMap<YangInstanceIdentifier.PathArgument, ModificationApplyOperation> initial, YangInstanceIdentifier.PathArgument identifier, ModificationApplyOperation computed) {
        ModificationApplyOperation raced;
        ImmutableMap<YangInstanceIdentifier.PathArgument, ModificationApplyOperation> previous = initial;
        do {
            ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)(previous.size() + 1));
            builder.putAll(previous);
            builder.put((Object)identifier, (Object)computed);
            ImmutableMap updated = builder.build();
            if (!UPDATER.compareAndSet(this, previous, updated)) continue;
            return Optional.of(computed);
        } while ((raced = (ModificationApplyOperation)(previous = this.children).get((Object)identifier)) == null);
        return Optional.of(raced);
    }
}

