/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import java.util.Optional;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.api.schema.tree.IncorrectDataStructureException;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.MutableTreeNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.TreeNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.TreeNodeFactory;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.Version;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.DataContainerNodeAttrBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.NormalizedNodeContainerBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableUnkeyedListEntryNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.AutomaticLifecycleMixin;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ChildTrackingPolicy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.DataNodeContainerModificationStrategy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModificationPath;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModifiedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.NodeModification;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.NormalizedNodeContainerSupport;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.SchemaAwareApplyOperation;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

final class UnkeyedListModificationStrategy
extends SchemaAwareApplyOperation<ListSchemaNode> {
    private static final NormalizedNodeContainerSupport<YangInstanceIdentifier.NodeIdentifier, UnkeyedListEntryNode> ITEM_SUPPORT = new NormalizedNodeContainerSupport(UnkeyedListEntryNode.class, ImmutableUnkeyedListEntryNodeBuilder::create, ImmutableUnkeyedListEntryNodeBuilder::create);
    private final DataNodeContainerModificationStrategy<ListSchemaNode> entryStrategy;
    private final UnkeyedListNode emptyNode;

    UnkeyedListModificationStrategy(ListSchemaNode schema, DataTreeConfiguration treeConfig) {
        this.entryStrategy = new DataNodeContainerModificationStrategy<ListSchemaNode>(ITEM_SUPPORT, schema, treeConfig);
        this.emptyNode = ImmutableNodes.listNode(schema.getQName());
    }

    @Override
    ListSchemaNode getSchema() {
        return (ListSchemaNode)this.entryStrategy.getSchema();
    }

    @Override
    Optional<TreeNode> apply(ModifiedNode modification, Optional<TreeNode> storeMeta, Version version) {
        return AutomaticLifecycleMixin.apply((x$0, x$1, x$2) -> super.apply(x$0, x$1, x$2), this::applyWrite, this.emptyNode, modification, storeMeta, version);
    }

    @Override
    protected ChildTrackingPolicy getChildPolicy() {
        return ChildTrackingPolicy.ORDERED;
    }

    @Override
    protected TreeNode applyMerge(ModifiedNode modification, TreeNode currentMeta, Version version) {
        throw new IllegalStateException(String.format("Merge of modification %s on unkeyed list should never be called", modification));
    }

    @Override
    protected TreeNode applyTouch(ModifiedNode modification, TreeNode currentMeta, Version version) {
        throw new UnsupportedOperationException("UnkeyedList does not support subtree change.");
    }

    @Override
    protected TreeNode applyWrite(ModifiedNode modification, NormalizedNode<?, ?> newValue, Optional<TreeNode> currentMeta, Version version) {
        TreeNode newValueMeta = TreeNodeFactory.createTreeNode(newValue, (Version)version);
        if (modification.getChildren().isEmpty()) {
            return newValueMeta;
        }
        MutableTreeNode mutable = newValueMeta.mutable();
        mutable.setSubtreeVersion(version);
        DataContainerNodeAttrBuilder<YangInstanceIdentifier.NodeIdentifier, UnkeyedListEntryNode> dataBuilder = ImmutableUnkeyedListEntryNodeBuilder.create((UnkeyedListEntryNode)newValue);
        return this.mutateChildren(mutable, dataBuilder, version, modification.getChildren());
    }

    private TreeNode mutateChildren(MutableTreeNode meta, NormalizedNodeContainerBuilder data, Version nodeVersion, Iterable<ModifiedNode> modifications) {
        for (ModifiedNode mod : modifications) {
            YangInstanceIdentifier.PathArgument id = mod.getIdentifier();
            Optional cm = meta.getChild(id);
            Optional<TreeNode> result = this.resolveChildOperation(id).apply(mod, cm, nodeVersion);
            if (result.isPresent()) {
                TreeNode tn = result.get();
                meta.addChild(tn);
                data.addChild(tn.getData());
                continue;
            }
            meta.removeChild(id);
            data.removeChild(id);
        }
        meta.setData(data.build());
        return meta.seal();
    }

    @Override
    public Optional<ModificationApplyOperation> getChild(YangInstanceIdentifier.PathArgument child) {
        return child instanceof YangInstanceIdentifier.NodeIdentifier ? Optional.of(this.entryStrategy) : Optional.empty();
    }

    @Override
    void verifyValue(NormalizedNode<?, ?> value) {
    }

    @Override
    void recursivelyVerifyStructure(NormalizedNode<?, ?> value) {
    }

    @Override
    protected void checkTouchApplicable(ModificationPath path, NodeModification modification, Optional<TreeNode> current, Version version) throws IncorrectDataStructureException {
        throw new IncorrectDataStructureException(path.toInstanceIdentifier(), "Subtree modification is not allowed.");
    }

    @Override
    void mergeIntoModifiedNode(ModifiedNode node, NormalizedNode<?, ?> value, Version version) {
        node.write(value);
    }
}

