/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.osgi.jta.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import org.ops4j.pax.transx.tm.impl.AbstractActivator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleWiring;

public class Activator
extends AbstractActivator {
    public static final String PID = "org.ops4j.pax.transx.tm.narayana";
    public static final String INTERN_PACKAGE = "org.jboss.narayana.osgi.jta.internal";
    public static final String SERVER_CLASS = "org.jboss.narayana.osgi.jta.internal.OsgiServer";
    private Object service;

    @Override
    protected String getPid() {
        return PID;
    }

    @Override
    protected void doStart() throws Exception {
        ClassLoader classLoader = this.createClassLoader();
        Class<?> osgiServerClass = classLoader.loadClass(SERVER_CLASS);
        this.service = osgiServerClass.getConstructor(BundleContext.class, Dictionary.class).newInstance(this.getBundleContext(), this.getConfiguration());
        this.service.getClass().getMethod("start", new Class[0]).invoke(this.service, new Object[0]);
    }

    @Override
    protected void doStop() {
        if (this.service != null) {
            try {
                this.service.getClass().getMethod("stop", new Class[0]).invoke(this.service, new Object[0]);
            }
            catch (Throwable t) {
                this.warn("Error stopping service", t);
            }
            finally {
                this.service = null;
            }
        }
    }

    ClassLoader createClassLoader() {
        Bundle bundle = this.getBundleContext().getBundle();
        ArrayList<URL> urls = new ArrayList<URL>();
        String name = SERVER_CLASS.replace('.', '/') + ".class";
        URL url = bundle.getResource(name);
        String strUrl = url.toExternalForm();
        if (!strUrl.endsWith(name)) {
            throw new IllegalStateException();
        }
        strUrl = strUrl.substring(0, strUrl.length() - name.length());
        try {
            urls.add(new URL(strUrl));
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
        Collection resources = ((BundleWiring)bundle.adapt(BundleWiring.class)).listResources("/", "*.jar", 2);
        for (String resource : resources) {
            urls.add(bundle.getResource(resource));
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), new ClassLoader(this.getClass().getClassLoader()){

            @Override
            protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                if (name.startsWith(Activator.INTERN_PACKAGE)) {
                    throw new ClassNotFoundException(name);
                }
                return super.loadClass(name, resolve);
            }
        });
    }
}

