/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.osgi.jta.internal;

import com.arjuna.ats.jbossatx.jta.RecoveryManagerService;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.tm.XAResourceRecovery;
import org.ops4j.pax.transx.tm.LastResource;
import org.ops4j.pax.transx.tm.NamedResource;
import org.ops4j.pax.transx.tm.ResourceFactory;
import org.ops4j.pax.transx.tm.impl.AbstractTransactionManagerWrapper;

public class TransactionManagerWrapper
extends AbstractTransactionManagerWrapper<TransactionManager> {
    final RecoveryManagerService recoveryManagerService;
    final Map<String, ResourceFactory> resources = new HashMap<String, ResourceFactory>();
    final Map<ResourceFactory, XAResourceRecovery> recoverables = new HashMap<ResourceFactory, XAResourceRecovery>();

    public TransactionManagerWrapper(TransactionManager narayanaTransactionManager) {
        super(narayanaTransactionManager);
        this.recoveryManagerService = new RecoveryManagerService();
        this.recoveryManagerService.create();
        this.recoveryManagerService.start();
    }

    public boolean isLastResourceCommitSupported() {
        return true;
    }

    public synchronized void registerResource(final ResourceFactory resource) {
        XAResourceRecovery rr = () -> new XAResource[]{new XAResource(){
            NamedResource xares;
            {
                this.xares = resource.create();
            }

            @Override
            public void commit(Xid xid, boolean b) throws XAException {
                this.xares.commit(xid, b);
            }

            @Override
            public void end(Xid xid, int i) throws XAException {
                this.xares.end(xid, i);
                if ((i & 0x800000) != 0) {
                    resource.release(this.xares);
                }
            }

            @Override
            public void forget(Xid xid) throws XAException {
                this.xares.forget(xid);
            }

            @Override
            public int getTransactionTimeout() throws XAException {
                return this.xares.getTransactionTimeout();
            }

            @Override
            public boolean isSameRM(XAResource xaResource) throws XAException {
                return this.xares.isSameRM(xaResource);
            }

            @Override
            public int prepare(Xid xid) throws XAException {
                return this.xares.prepare(xid);
            }

            @Override
            public Xid[] recover(int i) throws XAException {
                return this.xares.recover(i);
            }

            @Override
            public void rollback(Xid xid) throws XAException {
                this.xares.rollback(xid);
            }

            @Override
            public boolean setTransactionTimeout(int i) throws XAException {
                return this.xares.setTransactionTimeout(i);
            }

            @Override
            public void start(Xid xid, int i) throws XAException {
                this.xares.start(xid, i);
            }
        }};
        this.recoveryManagerService.addXAResourceRecovery(rr);
        this.recoverables.put(resource, rr);
        this.resources.put(resource.getName(), resource);
    }

    public synchronized void unregisterResource(String name) {
        XAResourceRecovery rr;
        ResourceFactory resource = this.resources.remove(name);
        XAResourceRecovery xAResourceRecovery = rr = resource != null ? this.recoverables.remove(resource) : null;
        if (rr != null) {
            this.recoveryManagerService.removeXAResourceRecovery(rr);
        }
    }

    public synchronized ResourceFactory getResource(String name) {
        return this.resources.get(name);
    }

    @Override
    protected AbstractTransactionManagerWrapper.TransactionWrapper doCreateTransactionWrapper(Transaction tx) {
        return new NarayanaTransactionWrapper(tx);
    }

    class NarayanaTransactionWrapper
    extends AbstractTransactionManagerWrapper.TransactionWrapper {
        NamedResource original;
        NamedResource wrapped;

        NarayanaTransactionWrapper(Transaction transaction) {
            super(TransactionManagerWrapper.this, transaction);
        }

        @Override
        public void enlistResource(NamedResource xares) throws Exception {
            if (xares instanceof LastResource) {
                if (this.wrapped != null) {
                    throw new IllegalStateException();
                }
                this.original = xares;
                this.wrapped = (NamedResource)Proxy.newProxyInstance(xares.getClass().getClassLoader(), new Class[]{org.jboss.tm.LastResource.class, LastResource.class}, (proxy, method, args) -> method.invoke((Object)xares, args));
                super.enlistResource(this.wrapped);
            } else {
                super.enlistResource(xares);
            }
        }

        @Override
        public void delistResource(NamedResource xares, int flags) throws Exception {
            if (xares == this.original) {
                xares = this.wrapped;
            }
            super.delistResource(xares, flags);
        }
    }
}

